/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksigner;

import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;

class PasswordRetriever
implements AutoCloseable {
    public static final String SPEC_STDIN = "stdin";
    private final Map<File, BufferedReader> mFileReaders = new HashMap<File, BufferedReader>();
    private BufferedReader mStdIn;
    private boolean mClosed;

    PasswordRetriever() {
    }

    public String getPassword(String string, String string2) throws IOException {
        this.assertNotClosed();
        if (string.startsWith("pass:")) {
            return string.substring("pass:".length());
        }
        if (SPEC_STDIN.equals(string)) {
            Console console = System.console();
            if (console != null) {
                char[] cArray = console.readPassword(string2 + ": ", new Object[0]);
                if (cArray == null) {
                    throw new IOException("Failed to read " + string2 + ": console closed");
                }
                return new String(cArray);
            }
            if (this.mStdIn == null) {
                this.mStdIn = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset()));
            }
            System.out.println(string2 + ":");
            String string3 = this.mStdIn.readLine();
            if (string3 == null) {
                throw new IOException("Failed to read " + string2 + ": standard input closed");
            }
            return string3;
        }
        if (string.startsWith("file:")) {
            String string4;
            String string5 = string.substring("file:".length());
            File file = new File(string5).getCanonicalFile();
            BufferedReader bufferedReader = this.mFileReaders.get(file);
            if (bufferedReader == null) {
                bufferedReader = Files.newBufferedReader(file.toPath(), Charset.defaultCharset());
                this.mFileReaders.put(file, bufferedReader);
            }
            if ((string4 = bufferedReader.readLine()) == null) {
                throw new IOException("Failed to read " + string2 + " : end of file reached in " + file);
            }
            return string4;
        }
        if (string.startsWith("env:")) {
            String string6 = string.substring("env:".length());
            String string7 = System.getenv(string6);
            if (string7 == null) {
                throw new IOException("Failed to read " + string2 + ": environment variable " + string7 + " not specified");
            }
            return string7;
        }
        throw new IOException("Unsupported password spec for " + string2 + ": " + string);
    }

    private void assertNotClosed() {
        if (this.mClosed) {
            throw new IllegalStateException("Closed");
        }
    }

    @Override
    public void close() {
        if (this.mStdIn != null) {
            try {
                this.mStdIn.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.mStdIn = null;
            }
        }
        for (BufferedReader bufferedReader : this.mFileReaders.values()) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
        this.mFileReaders.clear();
        this.mClosed = true;
    }
}

