/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.zip;

import com.android.apksig.internal.util.ByteBufferSink;
import com.android.apksig.internal.zip.CentralDirectoryRecord;
import com.android.apksig.internal.zip.ZipUtils;
import com.android.apksig.util.DataSink;
import com.android.apksig.util.DataSource;
import com.android.apksig.zip.ZipFormatException;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class LocalFileRecord {
    private static final int RECORD_SIGNATURE = 67324752;
    private static final int HEADER_SIZE_BYTES = 30;
    private static final int GP_FLAGS_OFFSET = 6;
    private static final int COMPRESSION_METHOD_OFFSET = 8;
    private static final int CRC32_OFFSET = 14;
    private static final int COMPRESSED_SIZE_OFFSET = 18;
    private static final int UNCOMPRESSED_SIZE_OFFSET = 22;
    private static final int NAME_LENGTH_OFFSET = 26;
    private static final int EXTRA_LENGTH_OFFSET = 28;
    private static final int NAME_OFFSET = 30;
    private static final int DATA_DESCRIPTOR_SIZE_BYTES_WITHOUT_SIGNATURE = 12;
    private static final int DATA_DESCRIPTOR_SIGNATURE = 134695760;
    private final String mName;
    private final int mNameSizeBytes;
    private final ByteBuffer mExtra;
    private final long mStartOffsetInArchive;
    private final long mSize;
    private final int mDataStartOffset;
    private final long mDataSize;
    private final boolean mDataCompressed;
    private final long mUncompressedDataSize;
    private static final ByteBuffer EMPTY_BYTE_BUFFER = ByteBuffer.allocate(0);

    private LocalFileRecord(String string, int n, ByteBuffer byteBuffer, long l, long l2, int n2, long l3, boolean bl, long l4) {
        this.mName = string;
        this.mNameSizeBytes = n;
        this.mExtra = byteBuffer;
        this.mStartOffsetInArchive = l;
        this.mSize = l2;
        this.mDataStartOffset = n2;
        this.mDataSize = l3;
        this.mDataCompressed = bl;
        this.mUncompressedDataSize = l4;
    }

    public String getName() {
        return this.mName;
    }

    public ByteBuffer getExtra() {
        return this.mExtra.capacity() > 0 ? this.mExtra.slice() : this.mExtra;
    }

    public int getExtraFieldStartOffsetInsideRecord() {
        return 30 + this.mNameSizeBytes;
    }

    public long getStartOffsetInArchive() {
        return this.mStartOffsetInArchive;
    }

    public int getDataStartOffsetInRecord() {
        return this.mDataStartOffset;
    }

    public long getSize() {
        return this.mSize;
    }

    public boolean isDataCompressed() {
        return this.mDataCompressed;
    }

    public static LocalFileRecord getRecord(DataSource dataSource, CentralDirectoryRecord centralDirectoryRecord, long l) throws ZipFormatException, IOException {
        return LocalFileRecord.getRecord(dataSource, centralDirectoryRecord, l, true, true);
    }

    private static LocalFileRecord getRecord(DataSource dataSource, CentralDirectoryRecord centralDirectoryRecord, long l, boolean bl, boolean bl2) throws ZipFormatException, IOException {
        long l2;
        boolean bl3;
        int n;
        ByteBuffer byteBuffer;
        String string = centralDirectoryRecord.getName();
        int n2 = centralDirectoryRecord.getNameSizeBytes();
        int n3 = 30 + n2;
        long l3 = centralDirectoryRecord.getLocalFileHeaderOffset();
        long l4 = l3 + (long)n3;
        if (l4 >= l) {
            throw new ZipFormatException("Local File Header of " + string + " extends beyond start of Central" + " Directory. LFH end: " + l4 + ", CD start: " + l);
        }
        try {
            byteBuffer = dataSource.getByteBuffer(l3, n3);
        }
        catch (IOException iOException) {
            throw new IOException("Failed to read Local File Header of " + string, iOException);
        }
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int n4 = byteBuffer.getInt();
        if (n4 != 67324752) {
            throw new ZipFormatException("Not a Local File Header record for entry " + string + ". Signature: 0x" + Long.toHexString((long)n4 & 0xFFFFFFFFL));
        }
        short s = byteBuffer.getShort(6);
        boolean bl4 = (s & 8) != 0;
        long l5 = centralDirectoryRecord.getCrc32();
        long l6 = centralDirectoryRecord.getCompressedSize();
        long l7 = centralDirectoryRecord.getUncompressedSize();
        if (!bl4) {
            long l8 = ZipUtils.getUnsignedInt32(byteBuffer, 14);
            if (l8 != l5) {
                throw new ZipFormatException("CRC-32 mismatch between Local File Header and Central Directory for entry " + string + ". LFH: " + l8 + ", CD: " + l5);
            }
            long l9 = ZipUtils.getUnsignedInt32(byteBuffer, 18);
            if (l9 != l6) {
                throw new ZipFormatException("Compressed size mismatch between Local File Header and Central Directory for entry " + string + ". LFH: " + l9 + ", CD: " + l6);
            }
            long l10 = ZipUtils.getUnsignedInt32(byteBuffer, 22);
            if (l10 != l7) {
                throw new ZipFormatException("Uncompressed size mismatch between Local File Header and Central Directory for entry " + string + ". LFH: " + l10 + ", CD: " + l7);
            }
        }
        if ((n = ZipUtils.getUnsignedInt16(byteBuffer, 26)) > n2) {
            throw new ZipFormatException("Name mismatch between Local File Header and Central Directory for entry" + string + ". LFH: " + n + " bytes, CD: " + n2 + " bytes");
        }
        String string2 = CentralDirectoryRecord.getName(byteBuffer, 30, n);
        if (!string.equals(string2)) {
            throw new ZipFormatException("Name mismatch between Local File Header and Central Directory. LFH: \"" + string2 + "\", CD: \"" + string + "\"");
        }
        int n5 = ZipUtils.getUnsignedInt16(byteBuffer, 28);
        short s2 = byteBuffer.getShort(8);
        switch (s2) {
            case 0: {
                bl3 = false;
                break;
            }
            case 8: {
                bl3 = true;
                break;
            }
            default: {
                throw new ZipFormatException("Unsupported compression method of entry " + string + ": " + (s2 & 0xFFFF));
            }
        }
        long l11 = l3 + 30L + (long)n + (long)n5;
        long l12 = bl3 ? l6 : l7;
        long l13 = l11 + l12;
        if (l13 > l) {
            throw new ZipFormatException("Local File Header data of " + string + " overlaps with Central Directory" + ". LFH data start: " + l11 + ", LFH data end: " + l13 + ", CD start: " + l);
        }
        ByteBuffer byteBuffer2 = EMPTY_BYTE_BUFFER;
        if (bl && n5 > 0) {
            byteBuffer2 = dataSource.getByteBuffer(l3 + 30L + (long)n, n5);
        }
        long l14 = l13;
        if (bl2 && (s & 8) != 0) {
            l2 = l13 + 12L;
            if (l2 > l) {
                throw new ZipFormatException("Data Descriptor of " + string + " overlaps with Central Directory" + ". Data Descriptor end: " + l13 + ", CD start: " + l);
            }
            ByteBuffer byteBuffer3 = dataSource.getByteBuffer(l13, 4);
            byteBuffer3.order(ByteOrder.LITTLE_ENDIAN);
            if (byteBuffer3.getInt() == 134695760 && (l2 += 4L) > l) {
                throw new ZipFormatException("Data Descriptor of " + string + " overlaps with Central Directory" + ". Data Descriptor end: " + l13 + ", CD start: " + l);
            }
            l14 = l2;
        }
        l2 = l14 - l3;
        int n6 = 30 + n + n5;
        return new LocalFileRecord(string, n2, byteBuffer2, l3, l2, n6, l12, bl3, l7);
    }

    public long outputRecord(DataSource dataSource, DataSink dataSink) throws IOException {
        long l = this.getSize();
        dataSource.feed(this.getStartOffsetInArchive(), l, dataSink);
        return l;
    }

    public long outputRecordWithModifiedExtra(DataSource dataSource, ByteBuffer byteBuffer, DataSink dataSink) throws IOException {
        long l = this.getStartOffsetInArchive();
        int n = this.getExtraFieldStartOffsetInsideRecord();
        int n2 = byteBuffer.remaining();
        int n3 = n + n2;
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(n3);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        dataSource.copyTo(l, n, byteBuffer2);
        byteBuffer2.put(byteBuffer.slice());
        byteBuffer2.flip();
        ZipUtils.setUnsignedInt16(byteBuffer2, 28, n2);
        long l2 = byteBuffer2.remaining();
        dataSink.consume(byteBuffer2);
        long l3 = this.getSize() - (long)this.mDataStartOffset;
        dataSource.feed(l + (long)this.mDataStartOffset, l3, dataSink);
        return l2 += l3;
    }

    public static long outputRecordWithDeflateCompressedData(String string, int n, int n2, byte[] byArray, long l, long l2, DataSink dataSink) throws IOException {
        byte[] byArray2 = string.getBytes(StandardCharsets.UTF_8);
        int n3 = 30 + byArray2.length;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(67324752);
        ZipUtils.putUnsignedInt16(byteBuffer, 20);
        byteBuffer.putShort((short)2048);
        byteBuffer.putShort((short)8);
        ZipUtils.putUnsignedInt16(byteBuffer, n);
        ZipUtils.putUnsignedInt16(byteBuffer, n2);
        ZipUtils.putUnsignedInt32(byteBuffer, l);
        ZipUtils.putUnsignedInt32(byteBuffer, byArray.length);
        ZipUtils.putUnsignedInt32(byteBuffer, l2);
        ZipUtils.putUnsignedInt16(byteBuffer, byArray2.length);
        ZipUtils.putUnsignedInt16(byteBuffer, 0);
        byteBuffer.put(byArray2);
        if (byteBuffer.hasRemaining()) {
            throw new RuntimeException("pos: " + byteBuffer.position() + ", limit: " + byteBuffer.limit());
        }
        byteBuffer.flip();
        long l3 = byteBuffer.remaining();
        dataSink.consume(byteBuffer);
        dataSink.consume(byArray, 0, byArray.length);
        return l3 += (long)byArray.length;
    }

    public void outputUncompressedData(DataSource dataSource, DataSink dataSink) throws IOException, ZipFormatException {
        block16: {
            long l = this.mStartOffsetInArchive + (long)this.mDataStartOffset;
            try {
                if (this.mDataCompressed) {
                    try (InflateSinkAdapter inflateSinkAdapter = new InflateSinkAdapter(dataSink);){
                        dataSource.feed(l, this.mDataSize, inflateSinkAdapter);
                        long l2 = inflateSinkAdapter.getOutputByteCount();
                        if (l2 != this.mUncompressedDataSize) {
                            throw new ZipFormatException("Unexpected size of uncompressed data of " + this.mName + ". Expected: " + this.mUncompressedDataSize + " bytes" + ", actual: " + l2 + " bytes");
                        }
                        break block16;
                    }
                }
                dataSource.feed(l, this.mDataSize, dataSink);
            }
            catch (IOException iOException) {
                throw new IOException("Failed to read data of " + (this.mDataCompressed ? "compressed" : "uncompressed") + " entry " + this.mName, iOException);
            }
        }
    }

    public static void outputUncompressedData(DataSource dataSource, CentralDirectoryRecord centralDirectoryRecord, long l, DataSink dataSink) throws ZipFormatException, IOException {
        LocalFileRecord localFileRecord = LocalFileRecord.getRecord(dataSource, centralDirectoryRecord, l, false, false);
        localFileRecord.outputUncompressedData(dataSource, dataSink);
    }

    public static byte[] getUncompressedData(DataSource dataSource, CentralDirectoryRecord centralDirectoryRecord, long l) throws ZipFormatException, IOException {
        if (centralDirectoryRecord.getUncompressedSize() > Integer.MAX_VALUE) {
            throw new IOException(centralDirectoryRecord.getName() + " too large: " + centralDirectoryRecord.getUncompressedSize());
        }
        byte[] byArray = new byte[(int)centralDirectoryRecord.getUncompressedSize()];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        ByteBufferSink byteBufferSink = new ByteBufferSink(byteBuffer);
        LocalFileRecord.outputUncompressedData(dataSource, centralDirectoryRecord, l, byteBufferSink);
        return byArray;
    }

    private static class InflateSinkAdapter
    implements DataSink,
    Closeable {
        private final DataSink mDelegate;
        private Inflater mInflater = new Inflater(true);
        private byte[] mOutputBuffer;
        private byte[] mInputBuffer;
        private long mOutputByteCount;
        private boolean mClosed;

        private InflateSinkAdapter(DataSink dataSink) {
            this.mDelegate = dataSink;
        }

        @Override
        public void consume(byte[] byArray, int n, int n2) throws IOException {
            this.checkNotClosed();
            this.mInflater.setInput(byArray, n, n2);
            if (this.mOutputBuffer == null) {
                this.mOutputBuffer = new byte[65536];
            }
            while (!this.mInflater.finished()) {
                int n3;
                try {
                    n3 = this.mInflater.inflate(this.mOutputBuffer);
                }
                catch (DataFormatException dataFormatException) {
                    throw new IOException("Failed to inflate data", dataFormatException);
                }
                if (n3 == 0) {
                    return;
                }
                this.mDelegate.consume(this.mOutputBuffer, 0, n3);
                this.mOutputByteCount += (long)n3;
            }
        }

        @Override
        public void consume(ByteBuffer byteBuffer) throws IOException {
            this.checkNotClosed();
            if (byteBuffer.hasArray()) {
                this.consume(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
                byteBuffer.position(byteBuffer.limit());
            } else {
                if (this.mInputBuffer == null) {
                    this.mInputBuffer = new byte[65536];
                }
                while (byteBuffer.hasRemaining()) {
                    int n = Math.min(byteBuffer.remaining(), this.mInputBuffer.length);
                    byteBuffer.get(this.mInputBuffer, 0, n);
                    this.consume(this.mInputBuffer, 0, n);
                }
            }
        }

        public long getOutputByteCount() {
            return this.mOutputByteCount;
        }

        @Override
        public void close() throws IOException {
            this.mClosed = true;
            this.mInputBuffer = null;
            this.mOutputBuffer = null;
            if (this.mInflater != null) {
                this.mInflater.end();
                this.mInflater = null;
            }
        }

        private void checkNotClosed() {
            if (this.mClosed) {
                throw new IllegalStateException("Closed");
            }
        }
    }
}

