/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.util;

import com.android.apksig.util.DataSink;
import com.android.apksig.util.DataSource;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferDataSource
implements DataSource {
    private final ByteBuffer mBuffer;
    private final int mSize;

    public ByteBufferDataSource(ByteBuffer byteBuffer) {
        this(byteBuffer, true);
    }

    private ByteBufferDataSource(ByteBuffer byteBuffer, boolean bl) {
        this.mBuffer = bl ? byteBuffer.slice() : byteBuffer;
        this.mSize = byteBuffer.remaining();
    }

    @Override
    public long size() {
        return this.mSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer getByteBuffer(long l, int n) {
        this.checkChunkValid(l, n);
        int n2 = (int)l;
        int n3 = n2 + n;
        ByteBuffer byteBuffer = this.mBuffer;
        synchronized (byteBuffer) {
            this.mBuffer.position(0);
            this.mBuffer.limit(n3);
            this.mBuffer.position(n2);
            return this.mBuffer.slice();
        }
    }

    @Override
    public void copyTo(long l, int n, ByteBuffer byteBuffer) {
        byteBuffer.put(this.getByteBuffer(l, n));
    }

    @Override
    public void feed(long l, long l2, DataSink dataSink) throws IOException {
        if (l2 < 0L || l2 > (long)this.mSize) {
            throw new IllegalArgumentException("size: " + l2 + ", source size: " + this.mSize);
        }
        dataSink.consume(this.getByteBuffer(l, (int)l2));
    }

    @Override
    public ByteBufferDataSource slice(long l, long l2) {
        if (l == 0L && l2 == (long)this.mSize) {
            return this;
        }
        if (l2 < 0L || l2 > (long)this.mSize) {
            throw new IllegalArgumentException("size: " + l2 + ", source size: " + this.mSize);
        }
        return new ByteBufferDataSource(this.getByteBuffer(l, (int)l2), false);
    }

    private void checkChunkValid(long l, long l2) {
        if (l < 0L) {
            throw new IllegalArgumentException("offset: " + l);
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("size: " + l2);
        }
        if (l > (long)this.mSize) {
            throw new IllegalArgumentException("offset (" + l + ") > source size (" + this.mSize + ")");
        }
        long l3 = l + l2;
        if (l3 < l) {
            throw new IllegalArgumentException("offset (" + l + ") + size (" + l2 + ") overflow");
        }
        if (l3 > (long)this.mSize) {
            throw new IllegalArgumentException("offset (" + l + ") + size (" + l2 + ") > source size (" + this.mSize + ")");
        }
    }
}

