/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.v2;

import com.android.apksig.ApkVerifier;
import com.android.apksig.apk.ApkUtils;
import com.android.apksig.internal.apk.v2.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.v2.SignatureAlgorithm;
import com.android.apksig.internal.apk.v2.V2SchemeSigner;
import com.android.apksig.internal.util.ByteBufferDataSource;
import com.android.apksig.internal.util.DelegatingX509Certificate;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.internal.zip.ZipUtils;
import com.android.apksig.util.DataSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class V2SchemeVerifier {
    private static final long APK_SIG_BLOCK_MAGIC_HI = 3617552046287187010L;
    private static final long APK_SIG_BLOCK_MAGIC_LO = 2334950737559900225L;
    private static final int APK_SIG_BLOCK_MIN_SIZE = 32;
    private static final int APK_SIGNATURE_SCHEME_V2_BLOCK_ID = 1896449818;
    private static final char[] HEX_DIGITS = "01234567890abcdef".toCharArray();

    private V2SchemeVerifier() {
    }

    public static Result verify(DataSource dataSource, ApkUtils.ZipSections zipSections) throws IOException, NoSuchAlgorithmException, SignatureNotFoundException {
        Result result = new Result();
        SignatureInfo signatureInfo = V2SchemeVerifier.findSignature(dataSource, zipSections, result);
        DataSource dataSource2 = dataSource.slice(0L, signatureInfo.apkSigningBlockOffset);
        DataSource dataSource3 = dataSource.slice(signatureInfo.centralDirOffset, signatureInfo.eocdOffset - signatureInfo.centralDirOffset);
        ByteBuffer byteBuffer = signatureInfo.eocd;
        V2SchemeVerifier.verify(dataSource2, signatureInfo.signatureBlock, dataSource3, byteBuffer, result);
        return result;
    }

    private static void verify(DataSource dataSource, ByteBuffer byteBuffer, DataSource dataSource2, ByteBuffer byteBuffer2, Result result) throws IOException, NoSuchAlgorithmException {
        HashSet<ContentDigestAlgorithm> hashSet = new HashSet<ContentDigestAlgorithm>(1);
        V2SchemeVerifier.parseSigners(byteBuffer, hashSet, result);
        if (result.containsErrors()) {
            return;
        }
        V2SchemeVerifier.verifyIntegrity(dataSource, dataSource2, byteBuffer2, hashSet, result);
        if (!result.containsErrors()) {
            result.verified = true;
        }
    }

    private static void parseSigners(ByteBuffer byteBuffer, Set<ContentDigestAlgorithm> set, Result result) throws NoSuchAlgorithmException {
        CertificateFactory certificateFactory;
        ByteBuffer byteBuffer2;
        try {
            byteBuffer2 = V2SchemeVerifier.getLengthPrefixedSlice(byteBuffer);
        }
        catch (IOException iOException) {
            result.addError(ApkVerifier.Issue.V2_SIG_MALFORMED_SIGNERS, new Object[0]);
            return;
        }
        if (!byteBuffer2.hasRemaining()) {
            result.addError(ApkVerifier.Issue.V2_SIG_NO_SIGNERS, new Object[0]);
            return;
        }
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new RuntimeException("Failed to obtain X.509 CertificateFactory", certificateException);
        }
        int n = 0;
        while (byteBuffer2.hasRemaining()) {
            int n2 = n++;
            Result.SignerInfo signerInfo = new Result.SignerInfo();
            signerInfo.index = n2;
            result.signers.add(signerInfo);
            try {
                ByteBuffer byteBuffer3 = V2SchemeVerifier.getLengthPrefixedSlice(byteBuffer2);
                V2SchemeVerifier.parseSigner(byteBuffer3, certificateFactory, signerInfo, set);
            }
            catch (IOException | BufferUnderflowException exception) {
                signerInfo.addError(ApkVerifier.Issue.V2_SIG_MALFORMED_SIGNER, new Object[0]);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void parseSigner(ByteBuffer byteBuffer, CertificateFactory certificateFactory, Result.SignerInfo signerInfo, Set<ContentDigestAlgorithm> set) throws IOException, NoSuchAlgorithmException {
        ArrayList<Integer> arrayList;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        List<SupportedSignature> list;
        ByteBuffer byteBuffer2 = V2SchemeVerifier.getLengthPrefixedSlice(byteBuffer);
        byte[] byArray = new byte[byteBuffer2.remaining()];
        byteBuffer2.get(byArray);
        byteBuffer2.flip();
        signerInfo.signedData = byArray;
        ByteBuffer byteBuffer3 = V2SchemeVerifier.getLengthPrefixedSlice(byteBuffer);
        byte[] byArray2 = V2SchemeVerifier.readLengthPrefixedByteArray(byteBuffer);
        int n = 0;
        ArrayList<SupportedSignature> arrayList2 = new ArrayList<SupportedSignature>(1);
        while (byteBuffer3.hasRemaining()) {
            ++n;
            try {
                list = V2SchemeVerifier.getLengthPrefixedSlice(byteBuffer3);
                int n2 = ((ByteBuffer)((Object)list)).getInt();
                object4 = V2SchemeVerifier.readLengthPrefixedByteArray((ByteBuffer)((Object)list));
                signerInfo.signatures.add(new Result.SignerInfo.Signature(n2, (byte[])object4));
                object3 = SignatureAlgorithm.findById(n2);
                if (object3 == null) {
                    signerInfo.addWarning(ApkVerifier.Issue.V2_SIG_UNKNOWN_SIG_ALGORITHM, n2);
                    continue;
                }
                arrayList2.add(new SupportedSignature((SignatureAlgorithm)((Object)object3), (byte[])object4));
            }
            catch (IOException | BufferUnderflowException exception) {
                signerInfo.addError(ApkVerifier.Issue.V2_SIG_MALFORMED_SIGNATURE, n);
                return;
            }
        }
        if (signerInfo.signatures.isEmpty()) {
            signerInfo.addError(ApkVerifier.Issue.V2_SIG_NO_SIGNATURES, new Object[0]);
            return;
        }
        list = V2SchemeVerifier.getSignaturesToVerify(arrayList2);
        if (list.isEmpty()) {
            signerInfo.addError(ApkVerifier.Issue.V2_SIG_NO_SUPPORTED_SIGNATURES, new Object[0]);
            return;
        }
        Object object5 = list.iterator();
        while (object5.hasNext()) {
            PublicKey publicKey;
            object4 = (SupportedSignature)object5.next();
            object3 = ((SupportedSignature)object4).algorithm;
            String string = ((SignatureAlgorithm)((Object)object3)).getJcaSignatureAlgorithmAndParams().getFirst();
            object2 = ((SignatureAlgorithm)((Object)object3)).getJcaSignatureAlgorithmAndParams().getSecond();
            object = ((SignatureAlgorithm)((Object)object3)).getJcaKeyAlgorithm();
            try {
                publicKey = KeyFactory.getInstance((String)object).generatePublic(new X509EncodedKeySpec(byArray2));
            }
            catch (Exception exception) {
                signerInfo.addError(ApkVerifier.Issue.V2_SIG_MALFORMED_PUBLIC_KEY, exception);
                return;
            }
            try {
                arrayList = Signature.getInstance(string);
                ((Signature)((Object)arrayList)).initVerify(publicKey);
                if (object2 != null) {
                    ((Signature)((Object)arrayList)).setParameter((AlgorithmParameterSpec)object2);
                }
                byteBuffer2.position(0);
                ((Signature)((Object)arrayList)).update(byteBuffer2);
                byte[] byArray3 = ((SupportedSignature)object4).signature;
                if (!((Signature)((Object)arrayList)).verify(byArray3)) {
                    signerInfo.addError(ApkVerifier.Issue.V2_SIG_DID_NOT_VERIFY, object3);
                    return;
                }
                signerInfo.verifiedSignatures.put((SignatureAlgorithm)((Object)object3), byArray3);
                set.add(((SignatureAlgorithm)((Object)object3)).getContentDigestAlgorithm());
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | SignatureException generalSecurityException) {
                signerInfo.addError(ApkVerifier.Issue.V2_SIG_VERIFY_EXCEPTION, object3, generalSecurityException);
                return;
            }
        }
        byteBuffer2.position(0);
        object5 = V2SchemeVerifier.getLengthPrefixedSlice(byteBuffer2);
        object4 = V2SchemeVerifier.getLengthPrefixedSlice(byteBuffer2);
        object3 = V2SchemeVerifier.getLengthPrefixedSlice(byteBuffer2);
        int n3 = -1;
        while (((Buffer)object4).hasRemaining()) {
            ++n3;
            object2 = V2SchemeVerifier.readLengthPrefixedByteArray((ByteBuffer)object4);
            try {
                object = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream((byte[])object2));
            }
            catch (CertificateException certificateException) {
                signerInfo.addError(ApkVerifier.Issue.V2_SIG_MALFORMED_CERTIFICATE, n3, n3 + 1, certificateException);
                return;
            }
            object = new GuaranteedEncodedFormX509Certificate((X509Certificate)object, (byte[])object2);
            signerInfo.certs.add((X509Certificate)object);
        }
        if (signerInfo.certs.isEmpty()) {
            signerInfo.addError(ApkVerifier.Issue.V2_SIG_NO_CERTIFICATES, new Object[0]);
            return;
        }
        object2 = signerInfo.certs.get(0);
        object = ((Certificate)object2).getPublicKey().getEncoded();
        if (!Arrays.equals(byArray2, (byte[])object)) {
            signerInfo.addError(ApkVerifier.Issue.V2_SIG_PUBLIC_KEY_MISMATCH_BETWEEN_CERTIFICATE_AND_SIGNATURES_RECORD, V2SchemeVerifier.toHex((byte[])object), V2SchemeVerifier.toHex(byArray2));
            return;
        }
        int n4 = 0;
        while (((Buffer)object5).hasRemaining()) {
            ++n4;
            try {
                arrayList = V2SchemeVerifier.getLengthPrefixedSlice((ByteBuffer)object5);
                int n5 = ((ByteBuffer)((Object)arrayList)).getInt();
                byte[] object6 = V2SchemeVerifier.readLengthPrefixedByteArray(arrayList);
                signerInfo.contentDigests.add(new Result.SignerInfo.ContentDigest(n5, object6));
            }
            catch (IOException | BufferUnderflowException exception) {
                signerInfo.addError(ApkVerifier.Issue.V2_SIG_MALFORMED_DIGEST, n4);
                return;
            }
        }
        arrayList = new ArrayList<Integer>(signerInfo.signatures.size());
        for (Result.SignerInfo.Signature signature : signerInfo.signatures) {
            arrayList.add(signature.getAlgorithmId());
        }
        ArrayList arrayList3 = new ArrayList(signerInfo.contentDigests.size());
        for (Result.SignerInfo.ContentDigest contentDigest : signerInfo.contentDigests) {
            arrayList3.add(contentDigest.getSignatureAlgorithmId());
        }
        if (!arrayList.equals(arrayList3)) {
            signerInfo.addError(ApkVerifier.Issue.V2_SIG_SIG_ALG_MISMATCH_BETWEEN_SIGNATURES_AND_DIGESTS_RECORDS, arrayList, arrayList3);
            return;
        }
        boolean bl = false;
        while (((Buffer)object3).hasRemaining()) {
            void var20_35;
            ++var20_35;
            try {
                ByteBuffer byteBuffer4 = V2SchemeVerifier.getLengthPrefixedSlice((ByteBuffer)object3);
                int n2 = byteBuffer4.getInt();
                byte[] byArray3 = V2SchemeVerifier.readLengthPrefixedByteArray(byteBuffer4);
                signerInfo.additionalAttributes.add(new Result.SignerInfo.AdditionalAttribute(n2, byArray3));
                signerInfo.addWarning(ApkVerifier.Issue.V2_SIG_UNKNOWN_ADDITIONAL_ATTRIBUTE, n2);
            }
            catch (IOException | BufferUnderflowException exception) {
                signerInfo.addError(ApkVerifier.Issue.V2_SIG_MALFORMED_ADDITIONAL_ATTRIBUTE, (int)var20_35);
                return;
            }
        }
    }

    private static List<SupportedSignature> getSignaturesToVerify(List<SupportedSignature> list) {
        SignatureAlgorithm signatureAlgorithm = null;
        byte[] byArray = null;
        for (SupportedSignature supportedSignature : list) {
            SignatureAlgorithm signatureAlgorithm2 = supportedSignature.algorithm;
            if (signatureAlgorithm != null && V2SchemeVerifier.compareSignatureAlgorithm(signatureAlgorithm2, signatureAlgorithm) <= 0) continue;
            signatureAlgorithm = signatureAlgorithm2;
            byArray = supportedSignature.signature;
        }
        if (signatureAlgorithm == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new SupportedSignature(signatureAlgorithm, byArray));
    }

    private static int compareSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm, SignatureAlgorithm signatureAlgorithm2) {
        ContentDigestAlgorithm contentDigestAlgorithm = signatureAlgorithm.getContentDigestAlgorithm();
        ContentDigestAlgorithm contentDigestAlgorithm2 = signatureAlgorithm2.getContentDigestAlgorithm();
        return V2SchemeVerifier.compareContentDigestAlgorithm(contentDigestAlgorithm, contentDigestAlgorithm2);
    }

    private static int compareContentDigestAlgorithm(ContentDigestAlgorithm contentDigestAlgorithm, ContentDigestAlgorithm contentDigestAlgorithm2) {
        switch (contentDigestAlgorithm) {
            case CHUNKED_SHA256: {
                switch (contentDigestAlgorithm2) {
                    case CHUNKED_SHA256: {
                        return 0;
                    }
                    case CHUNKED_SHA512: {
                        return -1;
                    }
                }
                throw new IllegalArgumentException("Unknown alg2: " + (Object)((Object)contentDigestAlgorithm2));
            }
            case CHUNKED_SHA512: {
                switch (contentDigestAlgorithm2) {
                    case CHUNKED_SHA256: {
                        return 1;
                    }
                    case CHUNKED_SHA512: {
                        return 0;
                    }
                }
                throw new IllegalArgumentException("Unknown alg2: " + (Object)((Object)contentDigestAlgorithm2));
            }
        }
        throw new IllegalArgumentException("Unknown alg1: " + (Object)((Object)contentDigestAlgorithm));
    }

    private static void verifyIntegrity(DataSource dataSource, DataSource dataSource2, ByteBuffer byteBuffer, Set<ContentDigestAlgorithm> set, Result result) throws IOException, NoSuchAlgorithmException {
        Map<ContentDigestAlgorithm, byte[]> map;
        if (set.isEmpty()) {
            throw new RuntimeException("No content digests found");
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.remaining());
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer2.put(byteBuffer);
        byteBuffer2.flip();
        ZipUtils.setZipEocdCentralDirectoryOffset(byteBuffer2, dataSource.size());
        try {
            map = V2SchemeSigner.computeContentDigests(set, new DataSource[]{dataSource, dataSource2, new ByteBufferDataSource(byteBuffer2)});
        }
        catch (DigestException digestException) {
            throw new RuntimeException("Failed to compute content digests", digestException);
        }
        if (!set.equals(map.keySet())) {
            throw new RuntimeException("Mismatch between sets of requested and computed content digests . Requested: " + set + ", computed: " + map.keySet());
        }
        for (Result.SignerInfo signerInfo : result.signers) {
            for (Result.SignerInfo.ContentDigest contentDigest : signerInfo.contentDigests) {
                byte[] byArray;
                SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.findById(contentDigest.getSignatureAlgorithmId());
                if (signatureAlgorithm == null) continue;
                ContentDigestAlgorithm contentDigestAlgorithm = signatureAlgorithm.getContentDigestAlgorithm();
                byte[] byArray2 = contentDigest.getValue();
                if (!Arrays.equals(byArray2, byArray = map.get((Object)contentDigestAlgorithm))) {
                    signerInfo.addError(ApkVerifier.Issue.V2_SIG_APK_DIGEST_DID_NOT_VERIFY, new Object[]{contentDigestAlgorithm, V2SchemeVerifier.toHex(byArray2), V2SchemeVerifier.toHex(byArray)});
                    continue;
                }
                signerInfo.verifiedContentDigests.put(contentDigestAlgorithm, byArray);
            }
        }
    }

    private static SignatureInfo findSignature(DataSource dataSource, ApkUtils.ZipSections zipSections, Result result) throws IOException, SignatureNotFoundException {
        ByteBuffer byteBuffer = zipSections.getZipEndOfCentralDirectory();
        Pair<DataSource, Long> pair = V2SchemeVerifier.findApkSigningBlock(dataSource, zipSections);
        DataSource dataSource2 = pair.getFirst();
        long l = pair.getSecond();
        ByteBuffer byteBuffer2 = dataSource2.getByteBuffer(0L, (int)dataSource2.size());
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer byteBuffer3 = V2SchemeVerifier.findApkSignatureSchemeV2Block(byteBuffer2, result);
        return new SignatureInfo(byteBuffer3, l, zipSections.getZipCentralDirectoryOffset(), zipSections.getZipEndOfCentralDirectoryOffset(), byteBuffer);
    }

    public static Pair<DataSource, Long> findApkSigningBlock(DataSource dataSource, ApkUtils.ZipSections zipSections) throws IOException, SignatureNotFoundException {
        long l;
        long l2 = zipSections.getZipCentralDirectoryOffset();
        long l3 = l2 + zipSections.getZipCentralDirectorySizeBytes();
        if (l3 != (l = zipSections.getZipEndOfCentralDirectoryOffset())) {
            throw new SignatureNotFoundException("ZIP Central Directory is not immediately followed by End of Central Directory. CD end: " + l3 + ", EoCD start: " + l);
        }
        if (l2 < 32L) {
            throw new SignatureNotFoundException("APK too small for APK Signing Block. ZIP Central Directory offset: " + l2);
        }
        ByteBuffer byteBuffer = dataSource.getByteBuffer(l2 - 24L, 24);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        if (byteBuffer.getLong(8) != 2334950737559900225L || byteBuffer.getLong(16) != 3617552046287187010L) {
            throw new SignatureNotFoundException("No APK Signing Block before ZIP Central Directory");
        }
        long l4 = byteBuffer.getLong(0);
        if (l4 < (long)byteBuffer.capacity() || l4 > 0x7FFFFFF7L) {
            throw new SignatureNotFoundException("APK Signing Block size out of range: " + l4);
        }
        int n = (int)(l4 + 8L);
        long l5 = l2 - (long)n;
        if (l5 < 0L) {
            throw new SignatureNotFoundException("APK Signing Block offset out of range: " + l5);
        }
        ByteBuffer byteBuffer2 = dataSource.getByteBuffer(l5, 8);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        long l6 = byteBuffer2.getLong(0);
        if (l6 != l4) {
            throw new SignatureNotFoundException("APK Signing Block sizes in header and footer do not match: " + l6 + " vs " + l4);
        }
        return Pair.of(dataSource.slice(l5, n), l5);
    }

    private static ByteBuffer findApkSignatureSchemeV2Block(ByteBuffer byteBuffer, Result result) throws SignatureNotFoundException {
        V2SchemeVerifier.checkByteOrderLittleEndian(byteBuffer);
        ByteBuffer byteBuffer2 = V2SchemeVerifier.sliceFromTo(byteBuffer, 8, byteBuffer.capacity() - 24);
        int n = 0;
        while (byteBuffer2.hasRemaining()) {
            ++n;
            if (byteBuffer2.remaining() < 8) {
                throw new SignatureNotFoundException("Insufficient data to read size of APK Signing Block entry #" + n);
            }
            long l = byteBuffer2.getLong();
            if (l < 4L || l > Integer.MAX_VALUE) {
                throw new SignatureNotFoundException("APK Signing Block entry #" + n + " size out of range: " + l);
            }
            int n2 = (int)l;
            int n3 = byteBuffer2.position() + n2;
            if (n2 > byteBuffer2.remaining()) {
                throw new SignatureNotFoundException("APK Signing Block entry #" + n + " size out of range: " + n2 + ", available: " + byteBuffer2.remaining());
            }
            int n4 = byteBuffer2.getInt();
            if (n4 == 1896449818) {
                return V2SchemeVerifier.getByteBuffer(byteBuffer2, n2 - 4);
            }
            result.addWarning(ApkVerifier.Issue.APK_SIG_BLOCK_UNKNOWN_ENTRY_ID, n4);
            byteBuffer2.position(n3);
        }
        throw new SignatureNotFoundException("No APK Signature Scheme v2 block in APK Signing Block");
    }

    private static void checkByteOrderLittleEndian(ByteBuffer byteBuffer) {
        if (byteBuffer.order() != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException("ByteBuffer byte order must be little endian");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer sliceFromTo(ByteBuffer byteBuffer, int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("start: " + n);
        }
        if (n2 < n) {
            throw new IllegalArgumentException("end < start: " + n2 + " < " + n);
        }
        int n3 = byteBuffer.capacity();
        if (n2 > byteBuffer.capacity()) {
            throw new IllegalArgumentException("end > capacity: " + n2 + " > " + n3);
        }
        int n4 = byteBuffer.limit();
        int n5 = byteBuffer.position();
        try {
            byteBuffer.position(0);
            byteBuffer.limit(n2);
            byteBuffer.position(n);
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            byteBuffer2.order(byteBuffer.order());
            ByteBuffer byteBuffer3 = byteBuffer2;
            return byteBuffer3;
        }
        finally {
            byteBuffer.position(0);
            byteBuffer.limit(n4);
            byteBuffer.position(n5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer getByteBuffer(ByteBuffer byteBuffer, int n) throws BufferUnderflowException {
        if (n < 0) {
            throw new IllegalArgumentException("size: " + n);
        }
        int n2 = byteBuffer.limit();
        int n3 = byteBuffer.position();
        int n4 = n3 + n;
        if (n4 < n3 || n4 > n2) {
            throw new BufferUnderflowException();
        }
        byteBuffer.limit(n4);
        try {
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            byteBuffer2.order(byteBuffer.order());
            byteBuffer.position(n4);
            ByteBuffer byteBuffer3 = byteBuffer2;
            return byteBuffer3;
        }
        finally {
            byteBuffer.limit(n2);
        }
    }

    private static ByteBuffer getLengthPrefixedSlice(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer.remaining() < 4) {
            throw new IOException("Remaining buffer too short to contain length of length-prefixed field. Remaining: " + byteBuffer.remaining());
        }
        int n = byteBuffer.getInt();
        if (n < 0) {
            throw new IllegalArgumentException("Negative length");
        }
        if (n > byteBuffer.remaining()) {
            throw new IOException("Length-prefixed field longer than remaining buffer. Field length: " + n + ", remaining: " + byteBuffer.remaining());
        }
        return V2SchemeVerifier.getByteBuffer(byteBuffer, n);
    }

    private static byte[] readLengthPrefixedByteArray(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.getInt();
        if (n < 0) {
            throw new IOException("Negative length");
        }
        if (n > byteBuffer.remaining()) {
            throw new IOException("Underflow while reading length-prefixed value. Length: " + n + ", available: " + byteBuffer.remaining());
        }
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return byArray;
    }

    private static String toHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = (byArray[i] & 0xFF) >>> 4;
            int n3 = byArray[i] & 0xF;
            stringBuilder.append(HEX_DIGITS[n2]).append(HEX_DIGITS[n3]);
        }
        return stringBuilder.toString();
    }

    public static class Result {
        public boolean verified;
        public final List<SignerInfo> signers = new ArrayList<SignerInfo>();
        private final List<ApkVerifier.IssueWithParams> mWarnings = new ArrayList<ApkVerifier.IssueWithParams>();
        private final List<ApkVerifier.IssueWithParams> mErrors = new ArrayList<ApkVerifier.IssueWithParams>();

        public boolean containsErrors() {
            if (!this.mErrors.isEmpty()) {
                return true;
            }
            if (!this.signers.isEmpty()) {
                for (SignerInfo signerInfo : this.signers) {
                    if (!signerInfo.containsErrors()) continue;
                    return true;
                }
            }
            return false;
        }

        public void addError(ApkVerifier.Issue issue, Object ... objectArray) {
            this.mErrors.add(new ApkVerifier.IssueWithParams(issue, objectArray));
        }

        public void addWarning(ApkVerifier.Issue issue, Object ... objectArray) {
            this.mWarnings.add(new ApkVerifier.IssueWithParams(issue, objectArray));
        }

        public List<ApkVerifier.IssueWithParams> getErrors() {
            return this.mErrors;
        }

        public List<ApkVerifier.IssueWithParams> getWarnings() {
            return this.mWarnings;
        }

        public static class SignerInfo {
            public int index;
            public List<X509Certificate> certs = new ArrayList<X509Certificate>();
            public List<ContentDigest> contentDigests = new ArrayList<ContentDigest>();
            public Map<ContentDigestAlgorithm, byte[]> verifiedContentDigests = new HashMap<ContentDigestAlgorithm, byte[]>();
            public List<Signature> signatures = new ArrayList<Signature>();
            public Map<SignatureAlgorithm, byte[]> verifiedSignatures = new HashMap<SignatureAlgorithm, byte[]>();
            public List<AdditionalAttribute> additionalAttributes = new ArrayList<AdditionalAttribute>();
            public byte[] signedData;
            private final List<ApkVerifier.IssueWithParams> mWarnings = new ArrayList<ApkVerifier.IssueWithParams>();
            private final List<ApkVerifier.IssueWithParams> mErrors = new ArrayList<ApkVerifier.IssueWithParams>();

            public void addError(ApkVerifier.Issue issue, Object ... objectArray) {
                this.mErrors.add(new ApkVerifier.IssueWithParams(issue, objectArray));
            }

            public void addWarning(ApkVerifier.Issue issue, Object ... objectArray) {
                this.mWarnings.add(new ApkVerifier.IssueWithParams(issue, objectArray));
            }

            public boolean containsErrors() {
                return !this.mErrors.isEmpty();
            }

            public List<ApkVerifier.IssueWithParams> getErrors() {
                return this.mErrors;
            }

            public List<ApkVerifier.IssueWithParams> getWarnings() {
                return this.mWarnings;
            }

            public static class AdditionalAttribute {
                private final int mId;
                private final byte[] mValue;

                public AdditionalAttribute(int n, byte[] byArray) {
                    this.mId = n;
                    this.mValue = (byte[])byArray.clone();
                }

                public int getId() {
                    return this.mId;
                }

                public byte[] getValue() {
                    return (byte[])this.mValue.clone();
                }
            }

            public static class Signature {
                private final int mAlgorithmId;
                private final byte[] mValue;

                public Signature(int n, byte[] byArray) {
                    this.mAlgorithmId = n;
                    this.mValue = byArray;
                }

                public int getAlgorithmId() {
                    return this.mAlgorithmId;
                }

                public byte[] getValue() {
                    return this.mValue;
                }
            }

            public static class ContentDigest {
                private final int mSignatureAlgorithmId;
                private final byte[] mValue;

                public ContentDigest(int n, byte[] byArray) {
                    this.mSignatureAlgorithmId = n;
                    this.mValue = byArray;
                }

                public int getSignatureAlgorithmId() {
                    return this.mSignatureAlgorithmId;
                }

                public byte[] getValue() {
                    return this.mValue;
                }
            }
        }
    }

    private static class GuaranteedEncodedFormX509Certificate
    extends DelegatingX509Certificate {
        private byte[] mEncodedForm;

        public GuaranteedEncodedFormX509Certificate(X509Certificate x509Certificate, byte[] byArray) {
            super(x509Certificate);
            this.mEncodedForm = byArray != null ? (byte[])byArray.clone() : null;
        }

        @Override
        public byte[] getEncoded() throws CertificateEncodingException {
            return this.mEncodedForm != null ? (byte[])this.mEncodedForm.clone() : null;
        }
    }

    public static class SignatureNotFoundException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public SignatureNotFoundException(String string) {
            super(string);
        }

        public SignatureNotFoundException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    private static class SignatureInfo {
        private final ByteBuffer signatureBlock;
        private final long apkSigningBlockOffset;
        private final long centralDirOffset;
        private final long eocdOffset;
        private final ByteBuffer eocd;

        private SignatureInfo(ByteBuffer byteBuffer, long l, long l2, long l3, ByteBuffer byteBuffer2) {
            this.signatureBlock = byteBuffer;
            this.apkSigningBlockOffset = l;
            this.centralDirOffset = l2;
            this.eocdOffset = l3;
            this.eocd = byteBuffer2;
        }
    }

    private static class SupportedSignature {
        private final SignatureAlgorithm algorithm;
        private final byte[] signature;

        private SupportedSignature(SignatureAlgorithm signatureAlgorithm, byte[] byArray) {
            this.algorithm = signatureAlgorithm;
            this.signature = byArray;
        }
    }
}

