/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig;

import com.android.apksig.ApkSignerEngine;
import com.android.apksig.internal.apk.v1.DigestAlgorithm;
import com.android.apksig.internal.apk.v1.V1SchemeSigner;
import com.android.apksig.internal.apk.v2.V2SchemeSigner;
import com.android.apksig.internal.util.MessageDigestSink;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.util.DataSink;
import com.android.apksig.util.DataSinks;
import com.android.apksig.util.DataSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultApkSignerEngine
implements ApkSignerEngine {
    private final boolean mV1SigningEnabled;
    private final boolean mV2SigningEnabled;
    private final boolean mOtherSignersSignaturesPreserved;
    private final List<V1SchemeSigner.SignerConfig> mV1SignerConfigs;
    private final DigestAlgorithm mV1ContentDigestAlgorithm;
    private final List<V2SchemeSigner.SignerConfig> mV2SignerConfigs;
    private boolean mClosed;
    private boolean mV1SignaturePending;
    private final Set<String> mSignatureExpectedOutputJarEntryNames;
    private final Map<String, GetJarEntryDataDigestRequest> mOutputJarEntryDigestRequests = new HashMap<String, GetJarEntryDataDigestRequest>();
    private final Map<String, byte[]> mOutputJarEntryDigests = new HashMap<String, byte[]>();
    private final Map<String, byte[]> mEmittedSignatureJarEntryData = new HashMap<String, byte[]>();
    private final Map<String, GetJarEntryDataRequest> mOutputSignatureJarEntryDataRequests = new HashMap<String, GetJarEntryDataRequest>();
    private GetJarEntryDataRequest mInputJarManifestEntryDataRequest;
    private OutputJarSignatureRequestImpl mAddV1SignatureRequest;
    private boolean mV2SignaturePending;
    private OutputApkSigningBlockRequestImpl mAddV2SignatureRequest;

    private DefaultApkSignerEngine(List<SignerConfig> list, int n, boolean bl, boolean bl2, boolean bl3) throws InvalidKeyException {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("At least one signer config must be provided");
        }
        if (bl3) {
            throw new UnsupportedOperationException("Preserving other signer's signatures is not yet implemented");
        }
        this.mV1SigningEnabled = bl;
        this.mV2SigningEnabled = bl2;
        this.mOtherSignersSignaturesPreserved = bl3;
        this.mV1SignerConfigs = bl ? new ArrayList(list.size()) : Collections.emptyList();
        this.mV2SignerConfigs = bl2 ? new ArrayList(list.size()) : Collections.emptyList();
        this.mV1ContentDigestAlgorithm = bl ? V1SchemeSigner.getSuggestedContentDigestAlgorithm(n) : null;
        for (SignerConfig signerConfig : list) {
            Object object;
            List<X509Certificate> list2 = signerConfig.getCertificates();
            PublicKey publicKey = list2.get(0).getPublicKey();
            if (bl) {
                object = V1SchemeSigner.getSuggestedSignatureDigestAlgorithm(publicKey, n);
                V1SchemeSigner.SignerConfig signerConfig2 = new V1SchemeSigner.SignerConfig();
                signerConfig2.name = signerConfig.getName();
                signerConfig2.privateKey = signerConfig.getPrivateKey();
                signerConfig2.certificates = list2;
                signerConfig2.contentDigestAlgorithm = this.mV1ContentDigestAlgorithm;
                signerConfig2.signatureDigestAlgorithm = object;
                this.mV1SignerConfigs.add(signerConfig2);
            }
            if (!bl2) continue;
            object = new V2SchemeSigner.SignerConfig();
            ((V2SchemeSigner.SignerConfig)object).privateKey = signerConfig.getPrivateKey();
            ((V2SchemeSigner.SignerConfig)object).certificates = list2;
            ((V2SchemeSigner.SignerConfig)object).signatureAlgorithms = V2SchemeSigner.getSuggestedSignatureAlgorithms(publicKey, n);
            this.mV2SignerConfigs.add((V2SchemeSigner.SignerConfig)object);
        }
        this.mSignatureExpectedOutputJarEntryNames = bl ? V1SchemeSigner.getOutputEntryNames(this.mV1SignerConfigs) : Collections.emptySet();
    }

    @Override
    public void inputApkSigningBlock(DataSource dataSource) {
        this.checkNotClosed();
        if (dataSource == null || dataSource.size() == 0L) {
            return;
        }
        if (this.mOtherSignersSignaturesPreserved) {
            return;
        }
    }

    @Override
    public ApkSignerEngine.InputJarEntryInstructions inputJarEntry(String string) {
        this.checkNotClosed();
        ApkSignerEngine.InputJarEntryInstructions.OutputPolicy outputPolicy = this.getInputJarEntryOutputPolicy(string);
        switch (outputPolicy) {
            case SKIP: {
                return new ApkSignerEngine.InputJarEntryInstructions(ApkSignerEngine.InputJarEntryInstructions.OutputPolicy.SKIP);
            }
            case OUTPUT: {
                return new ApkSignerEngine.InputJarEntryInstructions(ApkSignerEngine.InputJarEntryInstructions.OutputPolicy.OUTPUT);
            }
            case OUTPUT_BY_ENGINE: {
                if ("META-INF/MANIFEST.MF".equals(string)) {
                    this.mInputJarManifestEntryDataRequest = new GetJarEntryDataRequest(string);
                    return new ApkSignerEngine.InputJarEntryInstructions(ApkSignerEngine.InputJarEntryInstructions.OutputPolicy.OUTPUT_BY_ENGINE, this.mInputJarManifestEntryDataRequest);
                }
                return new ApkSignerEngine.InputJarEntryInstructions(ApkSignerEngine.InputJarEntryInstructions.OutputPolicy.OUTPUT_BY_ENGINE);
            }
        }
        throw new RuntimeException("Unsupported output policy: " + (Object)((Object)outputPolicy));
    }

    @Override
    public ApkSignerEngine.InspectJarEntryRequest outputJarEntry(String string) {
        this.checkNotClosed();
        this.invalidateV2Signature();
        if (!this.mV1SigningEnabled) {
            return null;
        }
        if (V1SchemeSigner.isJarEntryDigestNeededInManifest(string)) {
            this.invalidateV1Signature();
            GetJarEntryDataDigestRequest getJarEntryDataDigestRequest = new GetJarEntryDataDigestRequest(string, V1SchemeSigner.getJcaMessageDigestAlgorithm(this.mV1ContentDigestAlgorithm));
            this.mOutputJarEntryDigestRequests.put(string, getJarEntryDataDigestRequest);
            this.mOutputJarEntryDigests.remove(string);
            return getJarEntryDataDigestRequest;
        }
        if (this.mSignatureExpectedOutputJarEntryNames.contains(string)) {
            GetJarEntryDataRequest getJarEntryDataRequest;
            this.invalidateV1Signature();
            if ("META-INF/MANIFEST.MF".equals(string)) {
                this.mInputJarManifestEntryDataRequest = getJarEntryDataRequest = new GetJarEntryDataRequest(string);
            } else {
                GetJarEntryDataRequest getJarEntryDataRequest2 = getJarEntryDataRequest = this.mEmittedSignatureJarEntryData.containsKey(string) ? new GetJarEntryDataRequest(string) : null;
            }
            if (getJarEntryDataRequest != null) {
                this.mOutputSignatureJarEntryDataRequests.put(string, getJarEntryDataRequest);
            }
            return getJarEntryDataRequest;
        }
        return null;
    }

    @Override
    public ApkSignerEngine.InputJarEntryInstructions.OutputPolicy inputJarEntryRemoved(String string) {
        this.checkNotClosed();
        return this.getInputJarEntryOutputPolicy(string);
    }

    @Override
    public void outputJarEntryRemoved(String string) {
        this.checkNotClosed();
        this.invalidateV2Signature();
        if (!this.mV1SigningEnabled) {
            return;
        }
        if (V1SchemeSigner.isJarEntryDigestNeededInManifest(string)) {
            this.invalidateV1Signature();
            this.mOutputJarEntryDigests.remove(string);
            this.mOutputJarEntryDigestRequests.remove(string);
            this.mOutputSignatureJarEntryDataRequests.remove(string);
            return;
        }
        if (this.mSignatureExpectedOutputJarEntryNames.contains(string)) {
            this.invalidateV1Signature();
            return;
        }
    }

    @Override
    public ApkSignerEngine.OutputJarSignatureRequest outputJarEntries() throws InvalidKeyException, SignatureException, NoSuchAlgorithmException {
        Object object;
        Object object2;
        Object object3;
        byte[] byArray;
        List<Object> list;
        this.checkNotClosed();
        if (!this.mV1SignaturePending) {
            return null;
        }
        if (this.mInputJarManifestEntryDataRequest != null && !this.mInputJarManifestEntryDataRequest.isDone()) {
            throw new IllegalStateException("Still waiting to inspect input APK's " + this.mInputJarManifestEntryDataRequest.getEntryName());
        }
        for (GetJarEntryDataDigestRequest object42 : this.mOutputJarEntryDigestRequests.values()) {
            list = object42.getEntryName();
            if (!object42.isDone()) {
                throw new IllegalStateException("Still waiting to inspect output APK's " + (String)((Object)list));
            }
            this.mOutputJarEntryDigests.put((String)((Object)list), object42.getDigest());
        }
        this.mOutputJarEntryDigestRequests.clear();
        for (GetJarEntryDataRequest getJarEntryDataRequest : this.mOutputSignatureJarEntryDataRequests.values()) {
            if (getJarEntryDataRequest.isDone()) continue;
            throw new IllegalStateException("Still waiting to inspect output APK's " + getJarEntryDataRequest.getEntryName());
        }
        List<Integer> list2 = this.mV2SigningEnabled ? Collections.singletonList(2) : Collections.emptyList();
        byte[] byArray2 = byArray = this.mInputJarManifestEntryDataRequest != null ? this.mInputJarManifestEntryDataRequest.getData() : null;
        if (this.mAddV1SignatureRequest == null || !this.mAddV1SignatureRequest.isDone()) {
            try {
                list = V1SchemeSigner.sign(this.mV1SignerConfigs, this.mV1ContentDigestAlgorithm, this.mOutputJarEntryDigests, list2, byArray);
            }
            catch (CertificateException certificateException) {
                throw new SignatureException("Failed to generate v1 signature", certificateException);
            }
        } else {
            object3 = V1SchemeSigner.generateManifestFile(this.mV1ContentDigestAlgorithm, this.mOutputJarEntryDigests, byArray);
            object2 = this.mEmittedSignatureJarEntryData.get("META-INF/MANIFEST.MF");
            if (!Arrays.equals(((V1SchemeSigner.OutputManifestFile)object3).contents, object2)) {
                try {
                    list = V1SchemeSigner.signManifest(this.mV1SignerConfigs, this.mV1ContentDigestAlgorithm, list2, (V1SchemeSigner.OutputManifestFile)object3);
                }
                catch (CertificateException certificateException) {
                    throw new SignatureException("Failed to generate v1 signature", certificateException);
                }
            } else {
                list = new ArrayList();
                for (Map.Entry entry : this.mEmittedSignatureJarEntryData.entrySet()) {
                    object = (String)entry.getKey();
                    byte[] byArray3 = (byte[])entry.getValue();
                    GetJarEntryDataRequest getJarEntryDataRequest = this.mOutputSignatureJarEntryDataRequests.get(object);
                    if (getJarEntryDataRequest == null) {
                        list.add(Pair.of(object, byArray3));
                        continue;
                    }
                    byte[] byArray4 = getJarEntryDataRequest.getData();
                    if (Arrays.equals(byArray3, byArray4)) continue;
                    list.add(Pair.of(object, byArray3));
                }
                if (list.isEmpty()) {
                    return null;
                }
            }
        }
        if (list.isEmpty()) {
            this.mV1SignaturePending = false;
            return null;
        }
        object3 = new ArrayList(list.size());
        object2 = list.iterator();
        while (object2.hasNext()) {
            Pair pair = (Pair)object2.next();
            String string = (String)pair.getFirst();
            object = (byte[])pair.getSecond();
            object3.add(new ApkSignerEngine.OutputJarSignatureRequest.JarEntry(string, (byte[])object));
            this.mEmittedSignatureJarEntryData.put(string, (byte[])object);
        }
        this.mAddV1SignatureRequest = new OutputJarSignatureRequestImpl((List)object3);
        return this.mAddV1SignatureRequest;
    }

    @Override
    public ApkSignerEngine.OutputApkSigningBlockRequest outputZipSections(DataSource dataSource, DataSource dataSource2, DataSource dataSource3) throws IOException, InvalidKeyException, SignatureException, NoSuchAlgorithmException {
        this.checkNotClosed();
        this.checkV1SigningDoneIfEnabled();
        if (!this.mV2SigningEnabled) {
            return null;
        }
        this.invalidateV2Signature();
        byte[] byArray = V2SchemeSigner.generateApkSigningBlock(dataSource, dataSource2, dataSource3, this.mV2SignerConfigs);
        this.mAddV2SignatureRequest = new OutputApkSigningBlockRequestImpl(byArray);
        return this.mAddV2SignatureRequest;
    }

    @Override
    public void outputDone() {
        this.checkNotClosed();
        this.checkV1SigningDoneIfEnabled();
        this.checkV2SigningDoneIfEnabled();
    }

    @Override
    public void close() {
        this.mClosed = true;
        this.mAddV1SignatureRequest = null;
        this.mInputJarManifestEntryDataRequest = null;
        this.mOutputJarEntryDigestRequests.clear();
        this.mOutputJarEntryDigests.clear();
        this.mEmittedSignatureJarEntryData.clear();
        this.mOutputSignatureJarEntryDataRequests.clear();
        this.mAddV2SignatureRequest = null;
    }

    private void invalidateV1Signature() {
        if (this.mV1SigningEnabled) {
            this.mV1SignaturePending = true;
        }
        this.invalidateV2Signature();
    }

    private void invalidateV2Signature() {
        if (this.mV2SigningEnabled) {
            this.mV2SignaturePending = true;
            this.mAddV2SignatureRequest = null;
        }
    }

    private void checkNotClosed() {
        if (this.mClosed) {
            throw new IllegalStateException("Engine closed");
        }
    }

    private void checkV1SigningDoneIfEnabled() {
        if (!this.mV1SignaturePending) {
            return;
        }
        if (this.mAddV1SignatureRequest == null) {
            throw new IllegalStateException("v1 signature (JAR signature) not yet generated. Skipped outputJarEntries()?");
        }
        if (!this.mAddV1SignatureRequest.isDone()) {
            throw new IllegalStateException("v1 signature (JAR signature) addition requested by outputJarEntries() hasn't been fulfilled");
        }
        for (Map.Entry<String, byte[]> entry : this.mEmittedSignatureJarEntryData.entrySet()) {
            String string = entry.getKey();
            byte[] byArray = entry.getValue();
            GetJarEntryDataRequest getJarEntryDataRequest = this.mOutputSignatureJarEntryDataRequests.get(string);
            if (getJarEntryDataRequest == null) {
                throw new IllegalStateException("APK entry " + string + " not yet output despite this having been" + " requested");
            }
            if (!getJarEntryDataRequest.isDone()) {
                throw new IllegalStateException("Still waiting to inspect output APK's " + string);
            }
            byte[] byArray2 = getJarEntryDataRequest.getData();
            if (Arrays.equals(byArray, byArray2)) continue;
            throw new IllegalStateException("Output APK entry " + string + " data differs from what was requested");
        }
        this.mV1SignaturePending = false;
    }

    private void checkV2SigningDoneIfEnabled() {
        if (!this.mV2SignaturePending) {
            return;
        }
        if (this.mAddV2SignatureRequest == null) {
            throw new IllegalStateException("v2 signature (APK Signature Scheme v2 signature) not yet generated. Skipped outputZipSections()?");
        }
        if (!this.mAddV2SignatureRequest.isDone()) {
            throw new IllegalStateException("v2 signature (APK Signature Scheme v2 signature) addition requested by outputZipSections() hasn't been fulfilled yet");
        }
        this.mAddV2SignatureRequest = null;
        this.mV2SignaturePending = false;
    }

    private ApkSignerEngine.InputJarEntryInstructions.OutputPolicy getInputJarEntryOutputPolicy(String string) {
        if (this.mSignatureExpectedOutputJarEntryNames.contains(string)) {
            return ApkSignerEngine.InputJarEntryInstructions.OutputPolicy.OUTPUT_BY_ENGINE;
        }
        if (this.mOtherSignersSignaturesPreserved || V1SchemeSigner.isJarEntryDigestNeededInManifest(string)) {
            return ApkSignerEngine.InputJarEntryInstructions.OutputPolicy.OUTPUT;
        }
        return ApkSignerEngine.InputJarEntryInstructions.OutputPolicy.SKIP;
    }

    public static class Builder {
        private final List<SignerConfig> mSignerConfigs;
        private final int mMinSdkVersion;
        private boolean mV1SigningEnabled = true;
        private boolean mV2SigningEnabled = true;
        private boolean mOtherSignersSignaturesPreserved;

        public Builder(List<SignerConfig> list, int n) {
            if (list.isEmpty()) {
                throw new IllegalArgumentException("At least one signer config must be provided");
            }
            this.mSignerConfigs = new ArrayList<SignerConfig>(list);
            this.mMinSdkVersion = n;
        }

        public DefaultApkSignerEngine build() throws InvalidKeyException {
            return new DefaultApkSignerEngine(this.mSignerConfigs, this.mMinSdkVersion, this.mV1SigningEnabled, this.mV2SigningEnabled, this.mOtherSignersSignaturesPreserved);
        }

        public Builder setV1SigningEnabled(boolean bl) {
            this.mV1SigningEnabled = bl;
            return this;
        }

        public Builder setV2SigningEnabled(boolean bl) {
            this.mV2SigningEnabled = bl;
            return this;
        }

        public Builder setOtherSignersSignaturesPreserved(boolean bl) {
            this.mOtherSignersSignaturesPreserved = bl;
            return this;
        }
    }

    public static class SignerConfig {
        private final String mName;
        private final PrivateKey mPrivateKey;
        private final List<X509Certificate> mCertificates;

        private SignerConfig(String string, PrivateKey privateKey, List<X509Certificate> list) {
            this.mName = string;
            this.mPrivateKey = privateKey;
            this.mCertificates = Collections.unmodifiableList(new ArrayList<X509Certificate>(list));
        }

        public String getName() {
            return this.mName;
        }

        public PrivateKey getPrivateKey() {
            return this.mPrivateKey;
        }

        public List<X509Certificate> getCertificates() {
            return this.mCertificates;
        }

        public static class Builder {
            private final String mName;
            private final PrivateKey mPrivateKey;
            private final List<X509Certificate> mCertificates;

            public Builder(String string, PrivateKey privateKey, List<X509Certificate> list) {
                this.mName = string;
                this.mPrivateKey = privateKey;
                this.mCertificates = new ArrayList<X509Certificate>(list);
            }

            public SignerConfig build() {
                return new SignerConfig(this.mName, this.mPrivateKey, this.mCertificates);
            }
        }
    }

    private static class GetJarEntryDataDigestRequest
    implements ApkSignerEngine.InspectJarEntryRequest {
        private final String mEntryName;
        private final String mJcaDigestAlgorithm;
        private final Object mLock = new Object();
        private boolean mDone;
        private DataSink mDataSink;
        private MessageDigest mMessageDigest;
        private byte[] mDigest;

        private GetJarEntryDataDigestRequest(String string, String string2) {
            this.mEntryName = string;
            this.mJcaDigestAlgorithm = string2;
        }

        @Override
        public String getEntryName() {
            return this.mEntryName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DataSink getDataSink() {
            Object object = this.mLock;
            synchronized (object) {
                this.checkNotDone();
                if (this.mDataSink == null) {
                    this.mDataSink = new MessageDigestSink(new MessageDigest[]{this.getMessageDigest()});
                }
                return this.mDataSink;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MessageDigest getMessageDigest() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mMessageDigest == null) {
                    try {
                        this.mMessageDigest = MessageDigest.getInstance(this.mJcaDigestAlgorithm);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new RuntimeException(this.mJcaDigestAlgorithm + " MessageDigest not available", noSuchAlgorithmException);
                    }
                }
                return this.mMessageDigest;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mDone) {
                    return;
                }
                this.mDone = true;
                this.mDigest = this.getMessageDigest().digest();
                this.mMessageDigest = null;
                this.mDataSink = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isDone() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mDone;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkNotDone() throws IllegalStateException {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mDone) {
                    throw new IllegalStateException("Already done");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] getDigest() {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mDone) {
                    throw new IllegalStateException("Not yet done");
                }
                return (byte[])this.mDigest.clone();
            }
        }
    }

    private static class GetJarEntryDataRequest
    implements ApkSignerEngine.InspectJarEntryRequest {
        private final String mEntryName;
        private final Object mLock = new Object();
        private boolean mDone;
        private DataSink mDataSink;
        private ByteArrayOutputStream mDataSinkBuf;

        private GetJarEntryDataRequest(String string) {
            this.mEntryName = string;
        }

        @Override
        public String getEntryName() {
            return this.mEntryName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DataSink getDataSink() {
            Object object = this.mLock;
            synchronized (object) {
                this.checkNotDone();
                if (this.mDataSinkBuf == null) {
                    this.mDataSinkBuf = new ByteArrayOutputStream();
                }
                if (this.mDataSink == null) {
                    this.mDataSink = DataSinks.asDataSink(this.mDataSinkBuf);
                }
                return this.mDataSink;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mDone) {
                    return;
                }
                this.mDone = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isDone() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mDone;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkNotDone() throws IllegalStateException {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mDone) {
                    throw new IllegalStateException("Already done");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] getData() {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mDone) {
                    throw new IllegalStateException("Not yet done");
                }
                return this.mDataSinkBuf != null ? this.mDataSinkBuf.toByteArray() : new byte[]{};
            }
        }
    }

    private static class OutputApkSigningBlockRequestImpl
    implements ApkSignerEngine.OutputApkSigningBlockRequest {
        private final byte[] mApkSigningBlock;
        private volatile boolean mDone;

        private OutputApkSigningBlockRequestImpl(byte[] byArray) {
            this.mApkSigningBlock = (byte[])byArray.clone();
        }

        @Override
        public byte[] getApkSigningBlock() {
            return (byte[])this.mApkSigningBlock.clone();
        }

        @Override
        public void done() {
            this.mDone = true;
        }

        private boolean isDone() {
            return this.mDone;
        }
    }

    private static class OutputJarSignatureRequestImpl
    implements ApkSignerEngine.OutputJarSignatureRequest {
        private final List<ApkSignerEngine.OutputJarSignatureRequest.JarEntry> mAdditionalJarEntries;
        private volatile boolean mDone;

        private OutputJarSignatureRequestImpl(List<ApkSignerEngine.OutputJarSignatureRequest.JarEntry> list) {
            this.mAdditionalJarEntries = Collections.unmodifiableList(new ArrayList<ApkSignerEngine.OutputJarSignatureRequest.JarEntry>(list));
        }

        @Override
        public List<ApkSignerEngine.OutputJarSignatureRequest.JarEntry> getAdditionalJarEntries() {
            return this.mAdditionalJarEntries;
        }

        @Override
        public void done() {
            this.mDone = true;
        }

        private boolean isDone() {
            return this.mDone;
        }
    }
}

