/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig;

import com.android.apksig.apk.ApkUtils;
import com.android.apksig.internal.apk.v1.V1SchemeVerifier;
import com.android.apksig.internal.apk.v2.V2SchemeVerifier;
import com.android.apksig.util.DataSource;
import com.android.apksig.util.DataSources;
import com.android.apksig.zip.ZipFormatException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ApkVerifier {
    private static final int APK_SIGNATURE_SCHEME_V2_ID = 2;
    private static final Map<Integer, String> SUPPORTED_APK_SIG_SCHEME_NAMES = Collections.singletonMap(2, "APK Signature Scheme v2");
    private final File mApkFile;
    private final DataSource mApkDataSource;
    private final int mMinSdkVersion;
    private final int mMaxSdkVersion;

    private ApkVerifier(File file, DataSource dataSource, int n, int n2) {
        this.mApkFile = file;
        this.mApkDataSource = dataSource;
        this.mMinSdkVersion = n;
        this.mMaxSdkVersion = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result verify() throws IOException, ZipFormatException, NoSuchAlgorithmException, IllegalStateException {
        try (Object object = null;){
            Object object2;
            DataSource dataSource;
            if (this.mApkDataSource != null) {
                dataSource = this.mApkDataSource;
            } else if (this.mApkFile != null) {
                object = object2 = new RandomAccessFile(this.mApkFile, "r");
                dataSource = DataSources.asDataSource((RandomAccessFile)object2, 0L, ((RandomAccessFile)object2).length());
            } else {
                throw new IllegalStateException("APK not provided");
            }
            object2 = ApkVerifier.verify(dataSource, this.mMinSdkVersion, this.mMaxSdkVersion);
            return object2;
        }
    }

    private static Result verify(DataSource dataSource, int n, int n2) throws IOException, ZipFormatException, NoSuchAlgorithmException {
        Iterator<Result.V1SchemeSignerInfo> iterator;
        Set<Integer> set;
        if (n < 0) {
            throw new IllegalArgumentException("minSdkVersion must not be negative: " + n);
        }
        if (n > n2) {
            throw new IllegalArgumentException("minSdkVersion (" + n + ") > maxSdkVersion (" + n2 + ")");
        }
        ApkUtils.ZipSections zipSections = ApkUtils.findZipSections(dataSource);
        Result result = new Result();
        if (n2 >= 24) {
            set = new HashSet(1);
            try {
                iterator = V2SchemeVerifier.verify(dataSource, zipSections);
                set.add(2);
                result.mergeFrom((V2SchemeVerifier.Result)((Object)iterator));
            }
            catch (V2SchemeVerifier.SignatureNotFoundException signatureNotFoundException) {
                // empty catch block
            }
            if (result.containsErrors()) {
                return result;
            }
        } else {
            set = Collections.emptySet();
        }
        if (n < 24 || set.isEmpty()) {
            iterator = V1SchemeVerifier.verify(dataSource, zipSections, SUPPORTED_APK_SIG_SCHEME_NAMES, set, n, n2);
            result.mergeFrom((V1SchemeVerifier.Result)((Object)iterator));
        }
        if (result.containsErrors()) {
            return result;
        }
        if (result.isVerifiedUsingV1Scheme() && result.isVerifiedUsingV2Scheme()) {
            Object object;
            int n3;
            Object object22;
            iterator = new ArrayList<Result.V1SchemeSignerInfo>(result.getV1SchemeSigners());
            ArrayList<Result.V2SchemeSignerInfo> object3 = new ArrayList<Result.V2SchemeSignerInfo>(result.getV2SchemeSigners());
            ArrayList<ByteArray> arrayList = new ArrayList<ByteArray>();
            ArrayList<ByteArray> arrayList2 = new ArrayList<ByteArray>();
            Iterator<Object> iterator2 = ((ArrayList)((Object)iterator)).iterator();
            while (iterator2.hasNext()) {
                object22 = (Result.V1SchemeSignerInfo)iterator2.next();
                try {
                    arrayList.add(new ByteArray(((Result.V1SchemeSignerInfo)object22).getCertificate().getEncoded()));
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw new RuntimeException("Failed to encode JAR signer " + ((Result.V1SchemeSignerInfo)object22).getName() + " certs", certificateEncodingException);
                }
            }
            for (Object object22 : object3) {
                try {
                    arrayList2.add(new ByteArray(((Result.V2SchemeSignerInfo)object22).getCertificate().getEncoded()));
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw new RuntimeException("Failed to encode APK Signature Scheme v2 signer (index: " + ((Result.V2SchemeSignerInfo)object22).getIndex() + ") certs", certificateEncodingException);
                }
            }
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                object22 = (ByteArray)arrayList.get(n3);
                if (arrayList2.contains(object22)) continue;
                object = (Result.V1SchemeSignerInfo)((ArrayList)((Object)iterator)).get(n3);
                ((Result.V1SchemeSignerInfo)object).addError(Issue.V2_SIG_MISSING, new Object[0]);
                break;
            }
            for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                object22 = (ByteArray)arrayList2.get(n3);
                if (arrayList.contains(object22)) continue;
                object = object3.get(n3);
                ((Result.V2SchemeSignerInfo)object).addError(Issue.JAR_SIG_MISSING, new Object[0]);
                break;
            }
        }
        if (result.containsErrors()) {
            return result;
        }
        result.setVerified();
        if (result.isVerifiedUsingV2Scheme()) {
            for (Result.V2SchemeSignerInfo v2SchemeSignerInfo : result.getV2SchemeSigners()) {
                result.addSignerCertificate(v2SchemeSignerInfo.getCertificate());
            }
        } else if (result.isVerifiedUsingV1Scheme()) {
            for (Result.V1SchemeSignerInfo v1SchemeSignerInfo : result.getV1SchemeSigners()) {
                result.addSignerCertificate(v1SchemeSignerInfo.getCertificate());
            }
        } else {
            throw new RuntimeException("APK considered verified, but has not verified using either v1 or v2 schemes");
        }
        return result;
    }

    public static class Builder {
        private final File mApkFile;
        private final DataSource mApkDataSource;
        private int mMinSdkVersion = 1;
        private int mMaxSdkVersion = Integer.MAX_VALUE;

        public Builder(File file) {
            if (file == null) {
                throw new NullPointerException("apk == null");
            }
            this.mApkFile = file;
            this.mApkDataSource = null;
        }

        public Builder(DataSource dataSource) {
            if (dataSource == null) {
                throw new NullPointerException("apk == null");
            }
            this.mApkDataSource = dataSource;
            this.mApkFile = null;
        }

        public Builder setMinCheckedPlatformVersion(int n) {
            this.mMinSdkVersion = n;
            this.mMaxSdkVersion = Integer.MAX_VALUE;
            return this;
        }

        public Builder setCheckedPlatformVersions(int n, int n2) {
            this.mMinSdkVersion = n;
            this.mMaxSdkVersion = n2;
            return this;
        }

        public ApkVerifier build() {
            return new ApkVerifier(this.mApkFile, this.mApkDataSource, this.mMinSdkVersion, this.mMaxSdkVersion);
        }
    }

    private static class ByteArray {
        private final byte[] mArray;
        private final int mHashCode;

        private ByteArray(byte[] byArray) {
            this.mArray = byArray;
            this.mHashCode = Arrays.hashCode(this.mArray);
        }

        public int hashCode() {
            return this.mHashCode;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ByteArray byteArray = (ByteArray)object;
            if (this.hashCode() != byteArray.hashCode()) {
                return false;
            }
            return Arrays.equals(this.mArray, byteArray.mArray);
        }
    }

    public static class IssueWithParams {
        private final Issue mIssue;
        private final Object[] mParams;

        public IssueWithParams(Issue issue, Object[] objectArray) {
            this.mIssue = issue;
            this.mParams = objectArray;
        }

        public Issue getIssue() {
            return this.mIssue;
        }

        public Object[] getParams() {
            return (Object[])this.mParams.clone();
        }

        public String toString() {
            return String.format(this.mIssue.getFormat(), this.mParams);
        }
    }

    public static enum Issue {
        JAR_SIG_NO_SIGNATURES("No JAR signatures"),
        JAR_SIG_NO_SIGNED_ZIP_ENTRIES("No JAR entries covered by JAR signatures"),
        JAR_SIG_DUPLICATE_ZIP_ENTRY("Duplicate entry: %1$s"),
        JAR_SIG_DUPLICATE_MANIFEST_SECTION("Duplicate section in META-INF/MANIFEST.MF: %1$s"),
        JAR_SIG_UNNNAMED_MANIFEST_SECTION("Malformed META-INF/MANIFEST.MF: invidual section #%1$d does not have a name"),
        JAR_SIG_UNNNAMED_SIG_FILE_SECTION("Malformed %1$s: invidual section #%2$d does not have a name"),
        JAR_SIG_NO_MANIFEST("Missing META-INF/MANIFEST.MF"),
        JAR_SIG_MISSING_ZIP_ENTRY_REFERENCED_IN_MANIFEST("%1$s entry referenced by META-INF/MANIFEST.MF not found in the APK"),
        JAR_SIG_NO_ZIP_ENTRY_DIGEST_IN_MANIFEST("No digest for %1$s in META-INF/MANIFEST.MF"),
        JAR_SIG_NO_ZIP_ENTRY_DIGEST_IN_SIG_FILE("No digest for %1$s in %2$s"),
        JAR_SIG_ZIP_ENTRY_NOT_SIGNED("%1$s entry not signed"),
        JAR_SIG_ZIP_ENTRY_SIGNERS_MISMATCH("Entries %1$s and %3$s are signed with different sets of signers : <%2$s> vs <%4$s>"),
        JAR_SIG_ZIP_ENTRY_DIGEST_DID_NOT_VERIFY("%2$s digest of %1$s does not match the digest specified in %3$s. Expected: <%5$s>, actual: <%4$s>"),
        JAR_SIG_MANIFEST_MAIN_SECTION_DIGEST_DID_NOT_VERIFY("%1$s digest of META-INF/MANIFEST.MF main section does not match the digest specified in %2$s. Expected: <%4$s>, actual: <%3$s>"),
        JAR_SIG_MANIFEST_SECTION_DIGEST_DID_NOT_VERIFY("%2$s digest of META-INF/MANIFEST.MF section for %1$s does not match the digest specified in %3$s. Expected: <%5$s>, actual: <%4$s>"),
        JAR_SIG_NO_MANIFEST_DIGEST_IN_SIG_FILE("%1$s does not specify digest of META-INF/MANIFEST.MF. This slows down verification."),
        JAR_SIG_NO_APK_SIG_STRIP_PROTECTION("APK is signed using APK Signature Scheme v2 but these signatures may be stripped without being detected because %1$s does not contain anti-stripping protections."),
        JAR_SIG_MISSING_FILE("Partial JAR signature. Found: %1$s, missing: %2$s"),
        JAR_SIG_VERIFY_EXCEPTION("Failed to verify JAR signature %1$s against %2$s: %3$s"),
        JAR_SIG_UNSUPPORTED_SIG_ALG("JAR signature %1$s uses digest algorithm %2$s and signature algorithm %3$s which is not supported on API Levels %4$s"),
        JAR_SIG_PARSE_EXCEPTION("Failed to parse JAR signature %1$s: %2$s"),
        JAR_SIG_MALFORMED_CERTIFICATE("Malformed certificate in JAR signature %1$s: %2$s"),
        JAR_SIG_DID_NOT_VERIFY("JAR signature %1$s did not verify against %2$s"),
        JAR_SIG_NO_SIGNERS("JAR signature %1$s contains no signers"),
        JAR_SIG_DUPLICATE_SIG_FILE_SECTION("Duplicate section in %1$s: %2$s"),
        JAR_SIG_MISSING_VERSION_ATTR_IN_SIG_FILE("Malformed %1$s: missing Signature-Version attribute"),
        JAR_SIG_UNKNOWN_APK_SIG_SCHEME_ID("JAR signature %1$s references unknown APK signature scheme ID: %2$d"),
        JAR_SIG_MISSING_APK_SIG_REFERENCED("JAR signature %1$s indicates the APK is signed using %3$s but no such signature was found. Signature stripped?"),
        JAR_SIG_UNPROTECTED_ZIP_ENTRY("%1$s not protected by signature. Unauthorized modifications to this JAR entry will not be detected. Delete or move the entry outside of META-INF/."),
        JAR_SIG_MISSING("No APK Signature Scheme v2 signature from this signer despite APK being v2 signed"),
        V2_SIG_MISSING("No APK Signature Scheme v2 signature from this signer despite APK being v2 signed"),
        V2_SIG_MALFORMED_SIGNERS("Malformed list of signers"),
        V2_SIG_MALFORMED_SIGNER("Malformed signer block"),
        V2_SIG_MALFORMED_PUBLIC_KEY("Malformed public key: %1$s"),
        V2_SIG_MALFORMED_CERTIFICATE("Malformed certificate #%2$d: %3$s"),
        V2_SIG_MALFORMED_SIGNATURE("Malformed APK Signature Scheme v2 signature record #%1$d"),
        V2_SIG_MALFORMED_DIGEST("Malformed APK Signature Scheme v2 digest record #%1$d"),
        V2_SIG_MALFORMED_ADDITIONAL_ATTRIBUTE("Malformed additional attribute #%1$d"),
        V2_SIG_NO_SIGNERS("No signers in APK Signature Scheme v2 signature"),
        V2_SIG_UNKNOWN_SIG_ALGORITHM("Unknown signature algorithm: %1$#x"),
        V2_SIG_UNKNOWN_ADDITIONAL_ATTRIBUTE("Unknown additional attribute: ID %1$#x"),
        V2_SIG_VERIFY_EXCEPTION("Failed to verify %1$s signature: %2$s"),
        V2_SIG_DID_NOT_VERIFY("%1$s signature over signed-data did not verify"),
        V2_SIG_NO_SIGNATURES("No signatures"),
        V2_SIG_NO_SUPPORTED_SIGNATURES("No supported signatures"),
        V2_SIG_NO_CERTIFICATES("No certificates"),
        V2_SIG_PUBLIC_KEY_MISMATCH_BETWEEN_CERTIFICATE_AND_SIGNATURES_RECORD("Public key mismatch between certificate and signature record: <%1$s> vs <%2$s>"),
        V2_SIG_SIG_ALG_MISMATCH_BETWEEN_SIGNATURES_AND_DIGESTS_RECORDS("Signature algorithms mismatch between signatures and digests records: %1$s vs %2$s"),
        V2_SIG_APK_DIGEST_DID_NOT_VERIFY("APK integrity check failed. %1$s digest mismatch. Expected: <%2$s>, actual: <%3$s>"),
        APK_SIG_BLOCK_UNKNOWN_ENTRY_ID("APK Signing Block contains unknown entry: ID %1$#x");

        private final String mFormat;

        private Issue(String string2) {
            this.mFormat = string2;
        }

        private String getFormat() {
            return this.mFormat;
        }
    }

    public static class Result {
        private final List<IssueWithParams> mErrors = new ArrayList<IssueWithParams>();
        private final List<IssueWithParams> mWarnings = new ArrayList<IssueWithParams>();
        private final List<X509Certificate> mSignerCerts = new ArrayList<X509Certificate>();
        private final List<V1SchemeSignerInfo> mV1SchemeSigners = new ArrayList<V1SchemeSignerInfo>();
        private final List<V1SchemeSignerInfo> mV1SchemeIgnoredSigners = new ArrayList<V1SchemeSignerInfo>();
        private final List<V2SchemeSignerInfo> mV2SchemeSigners = new ArrayList<V2SchemeSignerInfo>();
        private boolean mVerified;
        private boolean mVerifiedUsingV1Scheme;
        private boolean mVerifiedUsingV2Scheme;

        public boolean isVerified() {
            return this.mVerified;
        }

        private void setVerified() {
            this.mVerified = true;
        }

        public boolean isVerifiedUsingV1Scheme() {
            return this.mVerifiedUsingV1Scheme;
        }

        public boolean isVerifiedUsingV2Scheme() {
            return this.mVerifiedUsingV2Scheme;
        }

        public List<X509Certificate> getSignerCertificates() {
            return this.mSignerCerts;
        }

        private void addSignerCertificate(X509Certificate x509Certificate) {
            this.mSignerCerts.add(x509Certificate);
        }

        public List<V1SchemeSignerInfo> getV1SchemeSigners() {
            return this.mV1SchemeSigners;
        }

        public List<V1SchemeSignerInfo> getV1SchemeIgnoredSigners() {
            return this.mV1SchemeIgnoredSigners;
        }

        public List<V2SchemeSignerInfo> getV2SchemeSigners() {
            return this.mV2SchemeSigners;
        }

        public List<IssueWithParams> getErrors() {
            return this.mErrors;
        }

        public List<IssueWithParams> getWarnings() {
            return this.mWarnings;
        }

        private void mergeFrom(V1SchemeVerifier.Result result) {
            this.mVerifiedUsingV1Scheme = result.verified;
            this.mErrors.addAll(result.getErrors());
            this.mWarnings.addAll(result.getWarnings());
            for (V1SchemeVerifier.Result.SignerInfo signerInfo : result.signers) {
                this.mV1SchemeSigners.add(new V1SchemeSignerInfo(signerInfo));
            }
            for (V1SchemeVerifier.Result.SignerInfo signerInfo : result.ignoredSigners) {
                this.mV1SchemeIgnoredSigners.add(new V1SchemeSignerInfo(signerInfo));
            }
        }

        private void mergeFrom(V2SchemeVerifier.Result result) {
            this.mVerifiedUsingV2Scheme = result.verified;
            this.mErrors.addAll(result.getErrors());
            this.mWarnings.addAll(result.getWarnings());
            for (V2SchemeVerifier.Result.SignerInfo signerInfo : result.signers) {
                this.mV2SchemeSigners.add(new V2SchemeSignerInfo(signerInfo));
            }
        }

        public boolean containsErrors() {
            if (!this.mErrors.isEmpty()) {
                return true;
            }
            if (!this.mV1SchemeSigners.isEmpty()) {
                for (V1SchemeSignerInfo object : this.mV1SchemeSigners) {
                    if (!object.containsErrors()) continue;
                    return true;
                }
            }
            if (!this.mV2SchemeSigners.isEmpty()) {
                for (V2SchemeSignerInfo v2SchemeSignerInfo : this.mV2SchemeSigners) {
                    if (!v2SchemeSignerInfo.containsErrors()) continue;
                    return true;
                }
            }
            return false;
        }

        public static class V2SchemeSignerInfo {
            private final int mIndex;
            private final List<X509Certificate> mCerts;
            private final List<IssueWithParams> mErrors;
            private final List<IssueWithParams> mWarnings;

            private V2SchemeSignerInfo(V2SchemeVerifier.Result.SignerInfo signerInfo) {
                this.mIndex = signerInfo.index;
                this.mCerts = signerInfo.certs;
                this.mErrors = signerInfo.getErrors();
                this.mWarnings = signerInfo.getWarnings();
            }

            public int getIndex() {
                return this.mIndex;
            }

            public X509Certificate getCertificate() {
                return this.mCerts.isEmpty() ? null : this.mCerts.get(0);
            }

            public List<X509Certificate> getCertificates() {
                return this.mCerts;
            }

            private void addError(Issue issue, Object ... objectArray) {
                this.mErrors.add(new IssueWithParams(issue, objectArray));
            }

            public boolean containsErrors() {
                return !this.mErrors.isEmpty();
            }

            public List<IssueWithParams> getErrors() {
                return this.mErrors;
            }

            public List<IssueWithParams> getWarnings() {
                return this.mWarnings;
            }
        }

        public static class V1SchemeSignerInfo {
            private final String mName;
            private final List<X509Certificate> mCertChain;
            private final String mSignatureBlockFileName;
            private final String mSignatureFileName;
            private final List<IssueWithParams> mErrors;
            private final List<IssueWithParams> mWarnings;

            private V1SchemeSignerInfo(V1SchemeVerifier.Result.SignerInfo signerInfo) {
                this.mName = signerInfo.name;
                this.mCertChain = signerInfo.certChain;
                this.mSignatureBlockFileName = signerInfo.signatureBlockFileName;
                this.mSignatureFileName = signerInfo.signatureFileName;
                this.mErrors = signerInfo.getErrors();
                this.mWarnings = signerInfo.getWarnings();
            }

            public String getName() {
                return this.mName;
            }

            public String getSignatureBlockFileName() {
                return this.mSignatureBlockFileName;
            }

            public String getSignatureFileName() {
                return this.mSignatureFileName;
            }

            public X509Certificate getCertificate() {
                return this.mCertChain.isEmpty() ? null : this.mCertChain.get(0);
            }

            public List<X509Certificate> getCertificateChain() {
                return this.mCertChain;
            }

            public boolean containsErrors() {
                return !this.mErrors.isEmpty();
            }

            public List<IssueWithParams> getErrors() {
                return this.mErrors;
            }

            public List<IssueWithParams> getWarnings() {
                return this.mWarnings;
            }

            private void addError(Issue issue, Object ... objectArray) {
                this.mErrors.add(new IssueWithParams(issue, objectArray));
            }
        }
    }
}

