/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig;

import com.android.apksig.ApkSignerEngine;
import com.android.apksig.apk.ApkUtils;
import com.android.apksig.internal.apk.v2.V2SchemeVerifier;
import com.android.apksig.internal.util.ByteBufferDataSource;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.internal.zip.CentralDirectoryRecord;
import com.android.apksig.internal.zip.EocdRecord;
import com.android.apksig.internal.zip.LocalFileRecord;
import com.android.apksig.internal.zip.ZipUtils;
import com.android.apksig.util.DataSink;
import com.android.apksig.util.DataSinks;
import com.android.apksig.util.DataSource;
import com.android.apksig.util.DataSources;
import com.android.apksig.zip.ZipFormatException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ApkSigner {
    private static final short ALIGNMENT_ZIP_EXTRA_DATA_FIELD_HEADER_ID = -9931;
    private static final short ALIGNMENT_ZIP_EXTRA_DATA_FIELD_MIN_SIZE_BYTES = 6;
    private final ApkSignerEngine mSignerEngine;
    private final File mInputApkFile;
    private final DataSource mInputApkDataSource;
    private final File mOutputApkFile;
    private final DataSink mOutputApkDataSink;
    private final DataSource mOutputApkDataSource;

    private ApkSigner(ApkSignerEngine apkSignerEngine, File file, DataSource dataSource, File file2, DataSink dataSink, DataSource dataSource2) {
        this.mSignerEngine = apkSignerEngine;
        this.mInputApkFile = file;
        this.mInputApkDataSource = dataSource;
        this.mOutputApkFile = file2;
        this.mOutputApkDataSink = dataSink;
        this.mOutputApkDataSource = dataSource2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sign() throws IOException, ZipFormatException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, IllegalStateException {
        try (Closeable closeable = null;){
            RandomAccessFile randomAccessFile;
            DataSource dataSource;
            if (this.mInputApkDataSource != null) {
                dataSource = this.mInputApkDataSource;
            } else if (this.mInputApkFile != null) {
                randomAccessFile = new RandomAccessFile(this.mInputApkFile, "r");
                closeable = randomAccessFile;
                dataSource = DataSources.asDataSource(randomAccessFile);
            } else {
                throw new IllegalStateException("Input APK not specified");
            }
            randomAccessFile = null;
            try {
                DataSource dataSource2;
                DataSink dataSink;
                if (this.mOutputApkDataSink != null) {
                    dataSink = this.mOutputApkDataSink;
                    dataSource2 = this.mOutputApkDataSource;
                } else if (this.mOutputApkFile != null) {
                    RandomAccessFile randomAccessFile2;
                    randomAccessFile = randomAccessFile2 = new RandomAccessFile(this.mOutputApkFile, "rw");
                    randomAccessFile2.setLength(0L);
                    dataSink = DataSinks.asDataSink(randomAccessFile2);
                    dataSource2 = DataSources.asDataSource(randomAccessFile2);
                } else {
                    throw new IllegalStateException("Output APK not specified");
                }
                ApkSigner.sign(this.mSignerEngine, dataSource, dataSink, dataSource2);
            }
            finally {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
        }
    }

    private static void sign(ApkSignerEngine apkSignerEngine, DataSource dataSource, DataSink dataSink, DataSource dataSource2) throws IOException, ZipFormatException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Object object;
        Object object2;
        long l;
        Object object32;
        Object object42;
        Object object5;
        Object object6;
        ApkUtils.ZipSections zipSections = ApkUtils.findZipSections(dataSource);
        long l2 = -1L;
        try {
            object6 = V2SchemeVerifier.findApkSigningBlock(dataSource, zipSections);
            apkSignerEngine.inputApkSigningBlock((DataSource)((Pair)object6).getFirst());
            l2 = (Long)((Pair)object6).getSecond();
        }
        catch (V2SchemeVerifier.SignatureNotFoundException signatureNotFoundException) {
            // empty catch block
        }
        object6 = ApkSigner.getZipCentralDirectory(dataSource, zipSections);
        List<CentralDirectoryRecord> list = ApkSigner.parseZipCentralDirectory((ByteBuffer)object6, zipSections);
        ArrayList<CentralDirectoryRecord> arrayList = new ArrayList<CentralDirectoryRecord>(list);
        Collections.sort(arrayList, CentralDirectoryRecord.BY_LOCAL_FILE_HEADER_OFFSET_COMPARATOR);
        DataSource dataSource3 = dataSource.slice(0L, l2 != -1L ? l2 : zipSections.getZipCentralDirectoryOffset());
        int n = -1;
        int n2 = -1;
        long l3 = 0L;
        long l4 = 0L;
        HashMap<String, CentralDirectoryRecord> hashMap = new HashMap<String, CentralDirectoryRecord>(list.size());
        for (CentralDirectoryRecord centralDirectoryRecord : arrayList) {
            boolean bl;
            String string = centralDirectoryRecord.getName();
            object5 = apkSignerEngine.inputJarEntry(string);
            switch (((ApkSignerEngine.InputJarEntryInstructions)object5).getOutputPolicy()) {
                case OUTPUT: {
                    bl = true;
                    break;
                }
                case OUTPUT_BY_ENGINE: 
                case SKIP: {
                    bl = false;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown output policy: " + (Object)((Object)((ApkSignerEngine.InputJarEntryInstructions)object5).getOutputPolicy()));
                }
            }
            long l5 = centralDirectoryRecord.getLocalFileHeaderOffset();
            if (l5 > l3) {
                long l6 = l5 - l3;
                dataSource3.feed(l3, l6, dataSink);
                l4 += l6;
                l3 = l5;
            }
            object42 = LocalFileRecord.getRecord(dataSource3, centralDirectoryRecord, dataSource3.size());
            l3 += ((LocalFileRecord)object42).getSize();
            object32 = ((ApkSignerEngine.InputJarEntryInstructions)object5).getInspectJarEntryRequest();
            if (object32 != null) {
                ApkSigner.fulfillInspectInputJarEntryRequest(dataSource3, object42, (ApkSignerEngine.InspectJarEntryRequest)object32);
            }
            if (!bl) continue;
            int n3 = centralDirectoryRecord.getLastModificationDate();
            int n4 = centralDirectoryRecord.getLastModificationTime();
            if (n == -1 || n3 > n || n3 == n && n4 > n2) {
                n = n3;
                n2 = n4;
            }
            if ((object32 = apkSignerEngine.outputJarEntry(string)) != null) {
                ApkSigner.fulfillInspectInputJarEntryRequest(dataSource3, (LocalFileRecord)object42, (ApkSignerEngine.InspectJarEntryRequest)object32);
            }
            long l7 = l4;
            l = ApkSigner.outputInputJarEntryLfhRecordPreservingDataAlignment(dataSource3, (LocalFileRecord)object42, dataSink, l7);
            l4 += l;
            CentralDirectoryRecord centralDirectoryRecord2 = l7 == ((LocalFileRecord)object42).getStartOffsetInArchive() ? centralDirectoryRecord : centralDirectoryRecord.createWithModifiedLocalFileHeaderOffset(l7);
            hashMap.put(string, centralDirectoryRecord2);
        }
        long l8 = dataSource3.size();
        if (l3 < l8) {
            long l9 = l8 - l3;
            dataSource3.feed(l3, l9, dataSink);
            l4 += l9;
            l3 = l8;
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>(list.size() + 10);
        for (CentralDirectoryRecord centralDirectoryRecord : list) {
            String string = centralDirectoryRecord.getName();
            object2 = (CentralDirectoryRecord)hashMap.get(string);
            if (object2 == null) continue;
            arrayList2.add(object2);
        }
        object5 = apkSignerEngine.outputJarEntries();
        if (object5 != null) {
            if (n == -1) {
                n = 14881;
                n2 = 0;
            }
            for (ApkSignerEngine.OutputJarSignatureRequest.JarEntry jarEntry : object5.getAdditionalJarEntries()) {
                object2 = jarEntry.getName();
                object42 = jarEntry.getData();
                object32 = ZipUtils.deflate(ByteBuffer.wrap((byte[])object42));
                byte[] byArray = ((ZipUtils.DeflateResult)object32).output;
                long l10 = ((ZipUtils.DeflateResult)object32).inputCrc32;
                object = apkSignerEngine.outputJarEntry((String)object2);
                if (object != null) {
                    object.getDataSink().consume((byte[])object42, 0, ((Object)object42).length);
                    object.done();
                }
                l = l4;
                l4 += LocalFileRecord.outputRecordWithDeflateCompressedData((String)object2, n2, n, byArray, l10, ((Object)object42).length, dataSink);
                arrayList2.add(CentralDirectoryRecord.createWithDeflateCompressedData((String)object2, n2, n, l10, byArray.length, ((Object)object42).length, l));
            }
            object5.done();
        }
        long l11 = 0L;
        for (Object object42 : arrayList2) {
            l11 += (long)((CentralDirectoryRecord)object42).getSize();
        }
        if (l11 > Integer.MAX_VALUE) {
            throw new IOException("Output ZIP Central Directory too large: " + l11 + " bytes");
        }
        object2 = ByteBuffer.allocate((int)l11);
        for (Object object32 : arrayList2) {
            ((CentralDirectoryRecord)object32).copyTo((ByteBuffer)object2);
        }
        ((ByteBuffer)object2).flip();
        object42 = new ByteBufferDataSource((ByteBuffer)object2);
        long l12 = l4;
        int n5 = arrayList2.size();
        ByteBuffer byteBuffer = EocdRecord.createWithModifiedCentralDirectoryInfo(zipSections.getZipEndOfCentralDirectory(), n5, object42.size(), l12);
        object = apkSignerEngine.outputZipSections(dataSource2, (DataSource)object42, DataSources.asDataSource(byteBuffer));
        if (object != null) {
            byte[] byArray = object.getApkSigningBlock();
            dataSink.consume(byArray, 0, byArray.length);
            ZipUtils.setZipEocdCentralDirectoryOffset(byteBuffer, l12 + (long)byArray.length);
            object.done();
        }
        object42.feed(0L, object42.size(), dataSink);
        dataSink.consume(byteBuffer);
        apkSignerEngine.outputDone();
    }

    private static void fulfillInspectInputJarEntryRequest(DataSource dataSource, LocalFileRecord localFileRecord, ApkSignerEngine.InspectJarEntryRequest inspectJarEntryRequest) throws IOException, ZipFormatException {
        localFileRecord.outputUncompressedData(dataSource, inspectJarEntryRequest.getDataSink());
        inspectJarEntryRequest.done();
    }

    private static long outputInputJarEntryLfhRecordPreservingDataAlignment(DataSource dataSource, LocalFileRecord localFileRecord, DataSink dataSink, long l) throws IOException {
        long l2 = localFileRecord.getStartOffsetInArchive();
        if (l2 == l) {
            return localFileRecord.outputRecord(dataSource, dataSink);
        }
        int n = ApkSigner.getInputJarEntryDataAlignmentMultiple(localFileRecord);
        if (n <= 1 || l2 % (long)n == l % (long)n) {
            return localFileRecord.outputRecord(dataSource, dataSink);
        }
        long l3 = l2 + (long)localFileRecord.getDataStartOffsetInRecord();
        if (l3 % (long)n != 0L) {
            return localFileRecord.outputRecord(dataSource, dataSink);
        }
        ByteBuffer byteBuffer = ApkSigner.createExtraFieldToAlignData(localFileRecord.getExtra(), l + (long)localFileRecord.getExtraFieldStartOffsetInsideRecord(), n);
        return localFileRecord.outputRecordWithModifiedExtra(dataSource, byteBuffer, dataSink);
    }

    private static int getInputJarEntryDataAlignmentMultiple(LocalFileRecord localFileRecord) {
        if (localFileRecord.isDataCompressed()) {
            return 1;
        }
        ByteBuffer byteBuffer = localFileRecord.getExtra();
        if (byteBuffer.hasRemaining()) {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            while (byteBuffer.remaining() >= 4) {
                short s = byteBuffer.getShort();
                int n = ZipUtils.getUnsignedInt16(byteBuffer);
                if (n > byteBuffer.remaining()) break;
                if (s != -9931) {
                    byteBuffer.position(byteBuffer.position() + n);
                    continue;
                }
                if (n < 2) break;
                return ZipUtils.getUnsignedInt16(byteBuffer);
            }
        }
        return localFileRecord.getName().endsWith(".so") ? 4096 : 4;
    }

    private static ByteBuffer createExtraFieldToAlignData(ByteBuffer byteBuffer, long l, int n) {
        int n2;
        if (n <= 1) {
            return byteBuffer;
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.remaining() + 5 + n);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        while (byteBuffer.remaining() >= 4) {
            short s = byteBuffer.getShort();
            int n3 = ZipUtils.getUnsignedInt16(byteBuffer);
            if (n3 > byteBuffer.remaining()) break;
            if (s == 0 && n3 == 0 || s == -9931) {
                byteBuffer.position(byteBuffer.position() + n3);
                continue;
            }
            byteBuffer.position(byteBuffer.position() - 4);
            n2 = byteBuffer.limit();
            byteBuffer.limit(byteBuffer.position() + 4 + n3);
            byteBuffer2.put(byteBuffer);
            byteBuffer.limit(n2);
        }
        long l2 = l + (long)byteBuffer2.position() + 6L;
        n2 = (n - (int)(l2 % (long)n)) % n;
        byteBuffer2.putShort((short)-9931);
        ZipUtils.putUnsignedInt16(byteBuffer2, 2 + n2);
        ZipUtils.putUnsignedInt16(byteBuffer2, n);
        byteBuffer2.position(byteBuffer2.position() + n2);
        byteBuffer2.flip();
        return byteBuffer2;
    }

    private static ByteBuffer getZipCentralDirectory(DataSource dataSource, ApkUtils.ZipSections zipSections) throws IOException, ZipFormatException {
        long l = zipSections.getZipCentralDirectorySizeBytes();
        if (l > Integer.MAX_VALUE) {
            throw new ZipFormatException("ZIP Central Directory too large: " + l);
        }
        long l2 = zipSections.getZipCentralDirectoryOffset();
        ByteBuffer byteBuffer = dataSource.getByteBuffer(l2, (int)l);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer;
    }

    private static List<CentralDirectoryRecord> parseZipCentralDirectory(ByteBuffer byteBuffer, ApkUtils.ZipSections zipSections) throws ZipFormatException {
        long l = zipSections.getZipCentralDirectoryOffset();
        int n = zipSections.getZipCentralDirectoryRecordCount();
        ArrayList<CentralDirectoryRecord> arrayList = new ArrayList<CentralDirectoryRecord>(n);
        HashSet<String> hashSet = new HashSet<String>(n);
        for (int i = 0; i < n; ++i) {
            CentralDirectoryRecord centralDirectoryRecord;
            int n2 = byteBuffer.position();
            try {
                centralDirectoryRecord = CentralDirectoryRecord.getRecord(byteBuffer);
            }
            catch (ZipFormatException zipFormatException) {
                throw new ZipFormatException("Failed to parse ZIP Central Directory record #" + (i + 1) + " at file offset " + (l + (long)n2), zipFormatException);
            }
            String string = centralDirectoryRecord.getName();
            if (!hashSet.add(string)) {
                throw new ZipFormatException("Malformed APK: multiple JAR entries with the same name: " + string);
            }
            arrayList.add(centralDirectoryRecord);
        }
        if (byteBuffer.hasRemaining()) {
            throw new ZipFormatException("Unused space at the end of ZIP Central Directory: " + byteBuffer.remaining() + " bytes starting at file offset " + (l + (long)byteBuffer.position()));
        }
        return arrayList;
    }

    public static class Builder {
        private final ApkSignerEngine mSignerEngine;
        private File mInputApkFile;
        private DataSource mInputApkDataSource;
        private File mOutputApkFile;
        private DataSink mOutputApkDataSink;
        private DataSource mOutputApkDataSource;

        public Builder(ApkSignerEngine apkSignerEngine) {
            this.mSignerEngine = apkSignerEngine;
        }

        public Builder setInputApk(File file) {
            if (file == null) {
                throw new NullPointerException("inputApk == null");
            }
            this.mInputApkFile = file;
            this.mInputApkDataSource = null;
            return this;
        }

        public Builder setInputApk(DataSource dataSource) {
            if (dataSource == null) {
                throw new NullPointerException("inputApk == null");
            }
            this.mInputApkDataSource = dataSource;
            this.mInputApkFile = null;
            return this;
        }

        public Builder setOutputApk(File file) {
            if (file == null) {
                throw new NullPointerException("outputApk == null");
            }
            this.mOutputApkFile = file;
            this.mOutputApkDataSink = null;
            this.mOutputApkDataSource = null;
            return this;
        }

        public Builder setOutputApk(DataSink dataSink, DataSource dataSource) {
            if (dataSink == null) {
                throw new NullPointerException("outputApkOut == null");
            }
            if (dataSource == null) {
                throw new NullPointerException("outputApkIn == null");
            }
            this.mOutputApkFile = null;
            this.mOutputApkDataSink = dataSink;
            this.mOutputApkDataSource = dataSource;
            return this;
        }

        public ApkSigner build() {
            return new ApkSigner(this.mSignerEngine, this.mInputApkFile, this.mInputApkDataSource, this.mOutputApkFile, this.mOutputApkDataSink, this.mOutputApkDataSource);
        }
    }
}

