/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.util;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.executor.impl.client.CancellationRequest;
import com.hazelcast.nio.Address;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.executor.DelegatingFuture;
import java.util.concurrent.CancellationException;

public final class ClientCancellableDelegatingFuture<V>
extends DelegatingFuture<V> {
    private final ClientContext context;
    private final String uuid;
    private final Address target;
    private final int partitionId;
    private volatile boolean cancelled;

    public ClientCancellableDelegatingFuture(ICompletableFuture future, ClientContext context, String uuid, Address target, int partitionId, V defaultValue) {
        super(future, context.getSerializationService(), defaultValue);
        this.context = context;
        this.uuid = uuid;
        this.target = target;
        this.partitionId = partitionId;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone() || this.cancelled) {
            return false;
        }
        Boolean b = false;
        try {
            b = this.invokeCancelRequest(mayInterruptIfRunning);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            if (b != null && b.booleanValue()) {
                this.setError(new CancellationException());
                this.cancelled = true;
                boolean e = true;
                return e;
            }
            boolean e = false;
            return e;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        finally {
            this.setDone();
        }
    }

    private Boolean invokeCancelRequest(boolean mayInterruptIfRunning) throws InterruptedException {
        ClientInvocation clientInvocation;
        CancellationRequest request;
        this.waitForRequestToBeSend();
        HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.context.getHazelcastInstance();
        if (this.target != null) {
            request = new CancellationRequest(this.uuid, this.target, mayInterruptIfRunning);
            clientInvocation = new ClientInvocation(client, (ClientRequest)request, this.target);
        } else {
            request = new CancellationRequest(this.uuid, this.partitionId, mayInterruptIfRunning);
            clientInvocation = new ClientInvocation(client, (ClientRequest)request, this.partitionId);
        }
        try {
            ClientInvocationFuture f = clientInvocation.invoke();
            return (Boolean)this.context.getSerializationService().toObject(f.get());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private void waitForRequestToBeSend() throws InterruptedException {
        ICompletableFuture future = this.getFuture();
        ClientInvocationFuture clientCallFuture = (ClientInvocationFuture)future;
        clientCallFuture.getInvocation().getSendConnectionOrWait();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

