/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.Binds;
import dagger.internal.codegen.AutoValue_Key;
import dagger.internal.codegen.AutoValue_Key_BindingMethodIdentifier;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.DelegateDeclaration;
import dagger.internal.codegen.FrameworkTypes;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.MoreAnnotationMirrors;
import dagger.internal.codegen.SetType;
import dagger.internal.codegen.SimpleAnnotationMirror;
import dagger.producers.Produced;
import dagger.producers.Producer;
import dagger.producers.Production;
import dagger.producers.internal.ProductionImplementation;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;

abstract class Key {
    Key() {
    }

    abstract Optional<Equivalence.Wrapper<AnnotationMirror>> wrappedQualifier();

    abstract Equivalence.Wrapper<TypeMirror> wrappedType();

    abstract Optional<BindingMethodIdentifier> bindingMethodIdentifier();

    Optional<AnnotationMirror> qualifier() {
        return MoreAnnotationMirrors.unwrapOptionalEquivalence(this.wrappedQualifier());
    }

    TypeMirror type() {
        return (TypeMirror)this.wrappedType().get();
    }

    private static TypeMirror normalize(Types types, TypeMirror type) {
        TypeKind kind = type.getKind();
        return kind.isPrimitive() ? types.boxedClass((PrimitiveType)type).asType() : type;
    }

    private Key withType(Types types, TypeMirror newType) {
        return new AutoValue_Key(this.wrappedQualifier(), (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)Key.normalize(types, newType)), this.bindingMethodIdentifier());
    }

    private Key withBindingMethodIdentifier(BindingMethodIdentifier bindingMethodIdentifier) {
        return new AutoValue_Key(this.wrappedQualifier(), this.wrappedType(), (Optional<BindingMethodIdentifier>)Optional.of((Object)bindingMethodIdentifier));
    }

    Key withoutBindingMethodIdentifier() {
        return new AutoValue_Key(this.wrappedQualifier(), this.wrappedType(), (Optional<BindingMethodIdentifier>)Optional.absent());
    }

    boolean isValidMembersInjectionKey() {
        return !this.qualifier().isPresent() && !this.type().getKind().equals((Object)TypeKind.WILDCARD);
    }

    boolean isValidImplicitProvisionKey(final Types types) {
        if (this.qualifier().isPresent()) {
            return false;
        }
        return this.type().accept(new SimpleTypeVisitor6<Boolean, Void>(){

            @Override
            protected Boolean defaultAction(TypeMirror e, Void p) {
                return false;
            }

            @Override
            public Boolean visitDeclared(DeclaredType type, Void ignored) {
                TypeElement element = MoreElements.asType(type.asElement());
                if (!element.getKind().equals((Object)ElementKind.CLASS) || element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    return false;
                }
                for (TypeMirror typeMirror : type.getTypeArguments()) {
                    if (typeMirror.getKind() == TypeKind.DECLARED) continue;
                    return false;
                }
                return MoreTypes.asDeclared(element.asType()).getTypeArguments().isEmpty() || !types.isSameType(types.erasure(element.asType()), Key.this.type());
            }
        }, null);
    }

    public String toString() {
        return MoreObjects.toStringHelper(Key.class).omitNullValues().add("qualifier", this.qualifier().orNull()).add("type", (Object)this.type()).add("bindingMethodIdentifier", this.bindingMethodIdentifier().orNull()).toString();
    }

    static <T extends HasKey> ImmutableSetMultimap<Key, T> indexByKey(Iterable<T> haveKeys) {
        return ImmutableSetMultimap.copyOf((Multimap)Multimaps.index(haveKeys, (Function)new Function<HasKey, Key>(){

            public Key apply(HasKey hasKey) {
                return hasKey.key();
            }
        }));
    }

    static final class Factory {
        private final Types types;
        private final Elements elements;

        Factory(Types types, Elements elements) {
            this.types = (Types)Preconditions.checkNotNull((Object)types);
            this.elements = (Elements)Preconditions.checkNotNull((Object)elements);
        }

        private TypeElement getSetElement() {
            return this.elements.getTypeElement(Set.class.getCanonicalName());
        }

        private TypeElement getMapElement() {
            return this.elements.getTypeElement(Map.class.getCanonicalName());
        }

        private TypeElement getProviderElement() {
            return this.elements.getTypeElement(Provider.class.getCanonicalName());
        }

        private TypeElement getProducerElement() {
            return this.elements.getTypeElement(Producer.class.getCanonicalName());
        }

        private TypeElement getClassElement(Class<?> cls) {
            return this.elements.getTypeElement(cls.getName());
        }

        Key forComponentMethod(ExecutableElement componentMethod) {
            Preconditions.checkNotNull((Object)componentMethod);
            Preconditions.checkArgument((boolean)componentMethod.getKind().equals((Object)ElementKind.METHOD));
            TypeMirror returnType = Key.normalize(this.types, componentMethod.getReturnType());
            return this.forMethod(componentMethod, returnType);
        }

        Key forProductionComponentMethod(ExecutableElement componentMethod) {
            TypeMirror returnType;
            Preconditions.checkNotNull((Object)componentMethod);
            Preconditions.checkArgument((boolean)componentMethod.getKind().equals((Object)ElementKind.METHOD));
            TypeMirror keyType = returnType = Key.normalize(this.types, componentMethod.getReturnType());
            if (MoreTypes.isTypeOf(ListenableFuture.class, returnType)) {
                keyType = (TypeMirror)Iterables.getOnlyElement(MoreTypes.asDeclared(returnType).getTypeArguments());
            }
            return this.forMethod(componentMethod, keyType);
        }

        Key forSubcomponentBuilderMethod(ExecutableElement subcomponentBuilderMethod, DeclaredType declaredContainer) {
            Preconditions.checkNotNull((Object)subcomponentBuilderMethod);
            Preconditions.checkArgument((boolean)subcomponentBuilderMethod.getKind().equals((Object)ElementKind.METHOD));
            ExecutableType resolvedMethod = MoreTypes.asExecutable(this.types.asMemberOf(declaredContainer, subcomponentBuilderMethod));
            TypeMirror returnType = Key.normalize(this.types, resolvedMethod.getReturnType());
            return this.forMethod(subcomponentBuilderMethod, returnType);
        }

        Key forProvidesMethod(ExecutableElement method, TypeElement contributingModule) {
            return this.forProvidesOrProducesMethod(method, contributingModule, this.getProviderElement());
        }

        Key forProducesMethod(ExecutableElement method, TypeElement contributingModule) {
            return this.forProvidesOrProducesMethod(method, contributingModule, this.getProducerElement());
        }

        private Key forProvidesOrProducesMethod(ExecutableElement method, TypeElement contributingModule, TypeElement frameworkType) {
            Preconditions.checkArgument((boolean)method.getKind().equals((Object)ElementKind.METHOD));
            ExecutableType methodType = MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(contributingModule.asType()), method));
            ContributionType contributionType = ContributionType.fromBindingMethod(method);
            TypeMirror returnType = Key.normalize(this.types, methodType.getReturnType());
            if (frameworkType.equals(this.getProducerElement()) && MoreTypes.isTypeOf(ListenableFuture.class, returnType)) {
                returnType = (TypeMirror)Iterables.getOnlyElement(MoreTypes.asDeclared(returnType).getTypeArguments());
            }
            TypeMirror keyType = this.bindingMethodKeyType(returnType, method, contributionType, (Optional<TypeElement>)Optional.of((Object)frameworkType));
            Key key = this.forMethod(method, keyType);
            return contributionType.equals((Object)ContributionType.UNIQUE) ? key : key.withBindingMethodIdentifier(BindingMethodIdentifier.create(method, contributingModule));
        }

        Key forMultibindsMethod(BindingType bindingType, ExecutableType executableType, ExecutableElement method) {
            Preconditions.checkArgument((boolean)method.getKind().equals((Object)ElementKind.METHOD), (String)"%s must be a method", (Object[])new Object[]{method});
            TypeElement factoryType = this.elements.getTypeElement(bindingType.frameworkClass().getCanonicalName());
            TypeMirror returnType = Key.normalize(this.types, executableType.getReturnType());
            TypeMirror keyType = MapType.isMap(returnType) ? this.mapOfFrameworkType(MapType.from(returnType).keyType(), factoryType, MapType.from(returnType).valueType()) : returnType;
            return this.forMethod(method, keyType);
        }

        Key forBindsMethod(ExecutableElement method, ExecutableType methodType) {
            Preconditions.checkArgument((boolean)MoreElements.isAnnotationPresent(method, Binds.class));
            ContributionType contributionType = ContributionType.fromBindingMethod(method);
            TypeMirror returnType = Key.normalize(this.types, methodType.getReturnType());
            TypeMirror keyType = this.bindingMethodKeyType(returnType, method, contributionType, (Optional<TypeElement>)Optional.absent());
            Key key = this.forMethod(method, keyType);
            return contributionType.equals((Object)ContributionType.UNIQUE) ? key : key.withBindingMethodIdentifier(BindingMethodIdentifier.create(method, MoreElements.asType(method.getEnclosingElement())));
        }

        private TypeMirror bindingMethodKeyType(TypeMirror returnType, ExecutableElement method, ContributionType contributionType, Optional<TypeElement> frameworkType) {
            switch (contributionType) {
                case UNIQUE: {
                    return returnType;
                }
                case SET: {
                    return this.types.getDeclaredType(this.getSetElement(), returnType);
                }
                case MAP: {
                    if (frameworkType.isPresent()) {
                        return this.mapOfFrameworkType(this.mapKeyType(method), (TypeElement)frameworkType.get(), returnType);
                    }
                    return this.types.getDeclaredType(this.getMapElement(), this.mapKeyType(method), returnType);
                }
                case SET_VALUES: {
                    Preconditions.checkArgument((boolean)SetType.isSet(returnType));
                    return returnType;
                }
            }
            throw new AssertionError();
        }

        Key forDelegateBinding(DelegateDeclaration delegateDeclaration, Class<?> frameworkType) {
            return delegateDeclaration.contributionType().equals((Object)ContributionType.MAP) ? this.wrapMapValue(delegateDeclaration.key(), frameworkType) : delegateDeclaration.key();
        }

        private TypeMirror mapOfFrameworkType(TypeMirror keyType, TypeElement frameworkType, TypeMirror valueType) {
            return this.types.getDeclaredType(this.getMapElement(), keyType, this.types.getDeclaredType(frameworkType, valueType));
        }

        private TypeMirror mapKeyType(ExecutableElement method) {
            AnnotationMirror mapKeyAnnotation = (AnnotationMirror)MapKeys.getMapKey(method).get();
            return MapKeys.unwrapValue(mapKeyAnnotation).isPresent() ? MapKeys.getUnwrappedMapKeyType(mapKeyAnnotation.getAnnotationType(), this.types) : mapKeyAnnotation.getAnnotationType();
        }

        private Key forMethod(ExecutableElement method, TypeMirror keyType) {
            return new AutoValue_Key(MoreAnnotationMirrors.wrapOptionalInEquivalence(InjectionAnnotations.getQualifier(method)), (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)keyType), (Optional<BindingMethodIdentifier>)Optional.absent());
        }

        Key forInjectConstructorWithResolvedType(TypeMirror type) {
            return new AutoValue_Key((Optional<Equivalence.Wrapper<AnnotationMirror>>)Optional.absent(), (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)type), (Optional<BindingMethodIdentifier>)Optional.absent());
        }

        Key forComponent(TypeMirror type) {
            return new AutoValue_Key((Optional<Equivalence.Wrapper<AnnotationMirror>>)Optional.absent(), (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)Key.normalize(this.types, type)), (Optional<BindingMethodIdentifier>)Optional.absent());
        }

        Key forMembersInjectedType(TypeMirror type) {
            return new AutoValue_Key((Optional<Equivalence.Wrapper<AnnotationMirror>>)Optional.absent(), (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)Key.normalize(this.types, type)), (Optional<BindingMethodIdentifier>)Optional.absent());
        }

        Key forQualifiedType(Optional<AnnotationMirror> qualifier, TypeMirror type) {
            return new AutoValue_Key(MoreAnnotationMirrors.wrapOptionalInEquivalence(qualifier), (Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)Key.normalize(this.types, type)), (Optional<BindingMethodIdentifier>)Optional.absent());
        }

        Key forProductionExecutor() {
            return this.forQualifiedType((Optional<AnnotationMirror>)Optional.of((Object)SimpleAnnotationMirror.of(this.getClassElement(Production.class))), this.getClassElement(Executor.class).asType());
        }

        Key forProductionImplementationExecutor() {
            return this.forQualifiedType((Optional<AnnotationMirror>)Optional.of((Object)SimpleAnnotationMirror.of(this.getClassElement(ProductionImplementation.class))), this.getClassElement(Executor.class).asType());
        }

        Optional<Key> implicitMapProviderKeyFrom(Key possibleMapKey) {
            return this.maybeWrapMapValue(possibleMapKey, Provider.class);
        }

        Optional<Key> implicitMapProducerKeyFrom(Key possibleMapKey) {
            return this.maybeRewrapMapValue(possibleMapKey, Produced.class, Producer.class).or(this.maybeWrapMapValue(possibleMapKey, Producer.class));
        }

        Key convertToDelegateKey(Key possibleMapKey) {
            TypeMirror wrappedValueType;
            if (!MapType.isMap(possibleMapKey)) {
                return possibleMapKey;
            }
            MapType mapType = MapType.from(possibleMapKey);
            if (mapType.valuesAreTypeOf(Provider.class)) {
                wrappedValueType = mapType.unwrappedValueType(Provider.class);
            } else if (mapType.valuesAreTypeOf(Producer.class)) {
                wrappedValueType = mapType.unwrappedValueType(Producer.class);
            } else {
                return possibleMapKey;
            }
            return possibleMapKey.withType(this.types, this.types.getDeclaredType(this.getMapElement(), mapType.keyType(), wrappedValueType));
        }

        private Key wrapMapValue(Key key, Class<?> newWrappingClass) {
            Preconditions.checkArgument((boolean)FrameworkTypes.isFrameworkType(this.elements.getTypeElement(newWrappingClass.getName()).asType()));
            return (Key)this.maybeWrapMapValue(key, newWrappingClass).get();
        }

        private Optional<Key> maybeRewrapMapValue(Key possibleMapKey, Class<?> currentWrappingClass, Class<?> newWrappingClass) {
            MapType mapType;
            Preconditions.checkArgument((!currentWrappingClass.equals(newWrappingClass) ? 1 : 0) != 0);
            if (MapType.isMap(possibleMapKey) && (mapType = MapType.from(possibleMapKey)).valuesAreTypeOf(currentWrappingClass)) {
                TypeElement wrappingElement = this.getClassElement(newWrappingClass);
                if (wrappingElement == null) {
                    return Optional.absent();
                }
                DeclaredType wrappedValueType = this.types.getDeclaredType(wrappingElement, mapType.unwrappedValueType(currentWrappingClass));
                DeclaredType wrappedMapType = this.types.getDeclaredType(this.getMapElement(), mapType.keyType(), wrappedValueType);
                return Optional.of((Object)possibleMapKey.withType(this.types, wrappedMapType));
            }
            return Optional.absent();
        }

        private Optional<Key> maybeWrapMapValue(Key possibleMapKey, Class<?> wrappingClass) {
            MapType mapType;
            if (MapType.isMap(possibleMapKey) && !(mapType = MapType.from(possibleMapKey)).valuesAreTypeOf(wrappingClass)) {
                TypeElement wrappingElement = this.getClassElement(wrappingClass);
                if (wrappingElement == null) {
                    return Optional.absent();
                }
                DeclaredType wrappedValueType = this.types.getDeclaredType(wrappingElement, mapType.valueType());
                DeclaredType wrappedMapType = this.types.getDeclaredType(this.getMapElement(), mapType.keyType(), wrappedValueType);
                return Optional.of((Object)possibleMapKey.withType(this.types, wrappedMapType));
            }
            return Optional.absent();
        }

        Optional<Key> implicitSetKeyFromProduced(Key possibleSetOfProducedKey) {
            TypeMirror argType;
            if (MoreTypes.isType(possibleSetOfProducedKey.type()) && MoreTypes.isTypeOf(Set.class, possibleSetOfProducedKey.type()) && MoreTypes.isType(argType = MoreTypes.asDeclared(possibleSetOfProducedKey.type()).getTypeArguments().get(0)) && MoreTypes.isTypeOf(Produced.class, argType)) {
                TypeMirror producedArgType = MoreTypes.asDeclared(argType).getTypeArguments().get(0);
                DeclaredType setType = this.types.getDeclaredType(this.getSetElement(), producedArgType);
                return Optional.of((Object)possibleSetOfProducedKey.withType(this.types, setType));
            }
            return Optional.absent();
        }

        Optional<Key> implicitProviderMapKeyFromProducer(Key possibleMapOfProducerKey) {
            return this.maybeRewrapMapValue(possibleMapOfProducerKey, Producer.class, Provider.class);
        }
    }

    static abstract class BindingMethodIdentifier {
        BindingMethodIdentifier() {
        }

        abstract ExecutableElement bindingMethod();

        abstract TypeElement contributingModule();

        static BindingMethodIdentifier create(ExecutableElement bindingMethod, TypeElement contributingModule) {
            return new AutoValue_Key_BindingMethodIdentifier(bindingMethod, contributingModule);
        }
    }

    static interface HasKey {
        public Key key();
    }
}

