/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.MoreAnnotationMirrors;
import dagger.internal.codegen.SetType;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Collection;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

abstract class ContributionBinding
extends Binding
implements ContributionType.HasContributionType {
    static final Function<ContributionBinding, Kind> KIND = new Function<ContributionBinding, Kind>(){

        public Kind apply(ContributionBinding binding) {
            return binding.bindingKind();
        }
    };

    ContributionBinding() {
    }

    @Override
    Set<DependencyRequest> implicitDependencies() {
        if (!this.membersInjectionRequest().isPresent()) {
            return this.dependencies();
        }
        return Sets.union((Set)this.membersInjectionRequest().asSet(), this.dependencies());
    }

    abstract Optional<DeclaredType> nullableType();

    boolean isSyntheticBinding() {
        return Kind.IS_SYNTHETIC_KIND.apply((Object)this.bindingKind());
    }

    abstract Optional<DependencyRequest> membersInjectionRequest();

    abstract Optional<Equivalence.Wrapper<AnnotationMirror>> wrappedMapKey();

    final Optional<AnnotationMirror> mapKey() {
        return MoreAnnotationMirrors.unwrapOptionalEquivalence(this.wrappedMapKey());
    }

    protected abstract Kind bindingKind();

    FactoryCreationStrategy factoryCreationStrategy() {
        switch (this.bindingKind()) {
            case SYNTHETIC_DELEGATE_BINDING: {
                return FactoryCreationStrategy.DELEGATE;
            }
            case PROVISION: {
                return this.implicitDependencies().isEmpty() && this.bindingElement().getModifiers().contains((Object)Modifier.STATIC) ? FactoryCreationStrategy.ENUM_INSTANCE : FactoryCreationStrategy.CLASS_CONSTRUCTOR;
            }
            case INJECTION: 
            case SYNTHETIC_MULTIBOUND_SET: 
            case SYNTHETIC_MULTIBOUND_MAP: {
                return this.implicitDependencies().isEmpty() ? FactoryCreationStrategy.ENUM_INSTANCE : FactoryCreationStrategy.CLASS_CONSTRUCTOR;
            }
        }
        return FactoryCreationStrategy.CLASS_CONSTRUCTOR;
    }

    final TypeMirror factoryType() {
        switch (this.contributionType()) {
            case MAP: {
                return MapType.from(this.key()).unwrappedValueType(this.frameworkClass());
            }
            case SET: {
                return SetType.from(this.key()).elementType();
            }
            case SET_VALUES: 
            case UNIQUE: {
                return this.key().type();
            }
        }
        throw new AssertionError();
    }

    static ImmutableSetMultimap<Object, ContributionBinding> indexMapBindingsByMapKey(Set<ContributionBinding> mapBindings) {
        return ImmutableSetMultimap.copyOf((Multimap)Multimaps.index(mapBindings, (Function)new Function<ContributionBinding, Object>(){

            public Object apply(ContributionBinding mapBinding) {
                AnnotationMirror mapKey = (AnnotationMirror)mapBinding.mapKey().get();
                Optional<? extends AnnotationValue> unwrappedValue = MapKeys.unwrapValue(mapKey);
                return unwrappedValue.isPresent() ? ((AnnotationValue)unwrappedValue.get()).getValue() : mapKey;
            }
        }));
    }

    static ImmutableSetMultimap<Equivalence.Wrapper<DeclaredType>, ContributionBinding> indexMapBindingsByAnnotationType(Set<ContributionBinding> mapBindings) {
        return ImmutableSetMultimap.copyOf((Multimap)Multimaps.index(mapBindings, (Function)new Function<ContributionBinding, Equivalence.Wrapper<DeclaredType>>(){

            public Equivalence.Wrapper<DeclaredType> apply(ContributionBinding mapBinding) {
                return MoreTypes.equivalence().wrap((Object)((AnnotationMirror)mapBinding.mapKey().get()).getAnnotationType());
            }
        }));
    }

    static enum FactoryCreationStrategy {
        ENUM_INSTANCE,
        CLASS_CONSTRUCTOR,
        DELEGATE;

    }

    static enum Kind {
        SYNTHETIC_MAP,
        SYNTHETIC_MULTIBOUND_SET,
        SYNTHETIC_MULTIBOUND_MAP,
        SYNTHETIC_DELEGATE_BINDING,
        INJECTION,
        PROVISION,
        COMPONENT,
        COMPONENT_PROVISION,
        SUBCOMPONENT_BUILDER,
        IMMEDIATE,
        FUTURE_PRODUCTION,
        COMPONENT_PRODUCTION;

        static final Predicate<Kind> IS_SYNTHETIC_KIND;
        static final Predicate<Kind> IS_SYNTHETIC_MULTIBINDING_KIND;

        static Kind forMultibindingRequest(DependencyRequest request) {
            Key key = request.key();
            if (SetType.isSet(key)) {
                return SYNTHETIC_MULTIBOUND_SET;
            }
            if (MapType.isMap(key)) {
                return SYNTHETIC_MULTIBOUND_MAP;
            }
            throw new IllegalArgumentException(String.format("request is not for a set or map: %s", request));
        }

        static {
            IS_SYNTHETIC_KIND = Predicates.in((Collection)Sets.immutableEnumSet((Enum)SYNTHETIC_MAP, (Enum[])new Kind[]{SYNTHETIC_MULTIBOUND_SET, SYNTHETIC_MULTIBOUND_MAP, SYNTHETIC_DELEGATE_BINDING}));
            IS_SYNTHETIC_MULTIBINDING_KIND = Predicates.in((Collection)Sets.immutableEnumSet((Enum)SYNTHETIC_MULTIBOUND_SET, (Enum[])new Kind[]{SYNTHETIC_MULTIBOUND_MAP}));
        }
    }
}

