/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.sym;

import com.sun.tools.javac.util.Assert;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class Profiles {
    public static void main(String[] args) throws IOException {
        Profiles p = Profiles.read(new File(args[0]));
        if (args.length >= 2) {
            TreeMap lists = new TreeMap();
            for (int i = 1; i <= 4; ++i) {
                lists.put(i, new TreeSet());
            }
            File rt_jar_lst = new File(args[1]);
            for (String line : Files.readAllLines(rt_jar_lst.toPath(), Charset.defaultCharset())) {
                int profile;
                if (!line.endsWith(".class")) continue;
                String type = line.substring(0, line.length() - 6);
                for (int i = profile = p.getProfile(type); i <= 4; ++i) {
                    ((Set)lists.get(i)).add(type);
                }
            }
            for (int i = 1; i <= 4; ++i) {
                try (BufferedWriter out = new BufferedWriter(new FileWriter(i + ".txt"));){
                    for (String type : (Set)lists.get(i)) {
                        out.write(type);
                        out.newLine();
                    }
                    continue;
                }
            }
        }
    }

    public static Profiles read(File file) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            Properties p = new Properties();
            p.load(in);
            if (p.containsKey("java/lang/Object")) {
                SimpleProfiles simpleProfiles = new SimpleProfiles(p);
                return simpleProfiles;
            }
            MakefileProfiles makefileProfiles = new MakefileProfiles(p);
            return makefileProfiles;
        }
    }

    public abstract int getProfileCount();

    public abstract int getProfile(String var1);

    public abstract Set<String> getPackages(int var1);

    private static class SimpleProfiles
    extends Profiles {
        private final Map<String, Integer> map;
        private final int profileCount;

        SimpleProfiles(Properties p) {
            int max = 0;
            this.map = new HashMap<String, Integer>();
            for (Map.Entry<Object, Object> e : p.entrySet()) {
                String typeName = (String)e.getKey();
                int profile = Integer.valueOf((String)e.getValue());
                this.map.put(typeName, profile);
                max = Math.max(max, profile);
            }
            this.profileCount = max;
        }

        @Override
        public int getProfileCount() {
            return this.profileCount;
        }

        @Override
        public int getProfile(String typeName) {
            return this.map.get(typeName);
        }

        @Override
        public Set<String> getPackages(int profile) {
            TreeSet<String> results = new TreeSet<String>();
            for (Map.Entry<String, Integer> e : this.map.entrySet()) {
                String tn = e.getKey();
                int prf = e.getValue();
                int sep = tn.lastIndexOf("/");
                if (sep <= 0 || profile < prf) continue;
                results.add(tn);
            }
            return results;
        }
    }

    private static class MakefileProfiles
    extends Profiles {
        final Map<String, Package> packages = new TreeMap<String, Package>();
        final int maxProfile = 4;

        MakefileProfiles(Properties p) {
            String prefix;
            String inclPackages;
            boolean foundJavaLang = false;
            for (int profile = 1; profile <= 4 && (inclPackages = p.getProperty((prefix = profile < 4 ? "PROFILE_" + profile : "FULL_JRE") + "_RTJAR_INCLUDE_PACKAGES")) != null; ++profile) {
                String exclTypes;
                for (String pkg : inclPackages.substring(1).trim().split("\\s+")) {
                    if (pkg.endsWith("/")) {
                        pkg = pkg.substring(0, pkg.length() - 1);
                    }
                    if (!foundJavaLang && pkg.equals("java/lang")) {
                        foundJavaLang = true;
                    }
                    this.includePackage(profile, pkg);
                }
                String inclTypes = p.getProperty(prefix + "_RTJAR_INCLUDE_TYPES");
                if (inclTypes != null) {
                    for (String type : inclTypes.replace("$$", "$").split("\\s+")) {
                        if (!type.endsWith(".class")) continue;
                        this.includeType(profile, type.substring(0, type.length() - 6));
                    }
                }
                if ((exclTypes = p.getProperty(prefix + "_RTJAR_EXCLUDE_TYPES")) == null) continue;
                for (String type : exclTypes.replace("$$", "$").split("\\s+")) {
                    if (!type.endsWith(".class")) continue;
                    this.excludeType(profile, type.substring(0, type.length() - 6));
                }
            }
            if (foundJavaLang) {
                this.includePackage(1, "javax/crypto");
            }
        }

        @Override
        public int getProfileCount() {
            return 4;
        }

        @Override
        public int getProfile(String typeName) {
            int sep = typeName.lastIndexOf("/");
            String packageName = typeName.substring(0, sep);
            String simpleName = typeName.substring(sep + 1);
            Package p = this.getPackage(packageName);
            return p.getProfile(simpleName);
        }

        @Override
        public Set<String> getPackages(int profile) {
            TreeSet<String> results = new TreeSet<String>();
            for (Package p : this.packages.values()) {
                p.getPackages(profile, results);
            }
            return results;
        }

        private void includePackage(int profile, String packageName) {
            Package p = this.getPackage(packageName);
            Assert.check(p.profile == 0);
            p.profile = profile;
        }

        private void includeType(int profile, String typeName) {
            int sep = typeName.lastIndexOf("/");
            String packageName = typeName.substring(0, sep);
            String simpleName = typeName.substring(sep + 1);
            Package p = this.getPackage(packageName);
            Assert.check(!p.includedTypes.containsKey(simpleName));
            p.includedTypes.put(simpleName, profile);
        }

        private void excludeType(int profile, String typeName) {
            int sep = typeName.lastIndexOf("/");
            String packageName = typeName.substring(0, sep);
            String simpleName = typeName.substring(sep + 1);
            Package p = this.getPackage(packageName);
            Assert.check(!p.excludedTypes.containsKey(simpleName));
            p.excludedTypes.put(simpleName, profile);
        }

        private Package getPackage(String packageName) {
            String simpleName;
            Map<String, Package> parentSubpackages;
            Package parent;
            int sep = packageName.lastIndexOf("/");
            if (sep == -1) {
                parent = null;
                parentSubpackages = this.packages;
                simpleName = packageName;
            } else {
                parent = this.getPackage(packageName.substring(0, sep));
                parentSubpackages = parent.subpackages;
                simpleName = packageName.substring(sep + 1);
            }
            Package p = parentSubpackages.get(simpleName);
            if (p == null) {
                p = new Package(parent, simpleName);
                parentSubpackages.put(simpleName, p);
            }
            return p;
        }

        static class Package {
            final Package parent;
            final String name;
            Map<String, Package> subpackages = new TreeMap<String, Package>();
            int profile;
            Map<String, Integer> includedTypes = new TreeMap<String, Integer>();
            Map<String, Integer> excludedTypes = new TreeMap<String, Integer>();

            Package(Package parent, String name) {
                this.parent = parent;
                this.name = name;
            }

            int getProfile() {
                return this.parent == null ? this.profile : Math.max(this.parent.getProfile(), this.profile);
            }

            int getProfile(String simpleTypeName) {
                Integer i = this.includedTypes.get(simpleTypeName);
                if (i != null) {
                    return i;
                }
                i = this.includedTypes.get("*");
                if (i != null) {
                    return i;
                }
                i = this.excludedTypes.get(simpleTypeName);
                if (i != null) {
                    return i + 1;
                }
                i = this.excludedTypes.get("*");
                if (i != null) {
                    return i + 1;
                }
                return this.getProfile();
            }

            String getName() {
                return this.parent == null ? this.name : this.parent.getName() + "/" + this.name;
            }

            void getPackages(int profile, Set<String> results) {
                int prf = this.getProfile();
                if (prf != 0 && profile >= prf) {
                    results.add(this.getName());
                }
                for (Package pkg : this.subpackages.values()) {
                    pkg.getPackages(profile, results);
                }
            }
        }
    }
}

